/*
 * Java
 *
 * Copyright 2013-2016 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.microej.kf.util.security;

import java.security.Permission;

import ej.kf.Feature;

/**
 * API for checking {@link Feature} permissions.
 */
public interface FeaturePermissionCheckDelegate {

	/**
	 * Called by {@link KernelSecurityManager} when the current thread context requesting for a Permission check is
	 * owned by a Feature. This method is called in Kernel mode.
	 * @param p
	 * 			the permission to check
	 * @param f
	 * 			the feature which own the permission
	 */
	public void checkPermission(Permission p, Feature f);
}