/*
 * Java
 *
 * 2015-2020 ESR - Not subject to Copyright.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui.display;

import java.io.InputStream;
import java.security.Permission;

import ej.annotation.Nullable;

/**
 * Permission to load or create an {@link Image}. Permission is checked when calling one of the following methods:<br>
 * - {@link Image#canGetImage(String)},<br>
 * - {@link Image#getImage(String)},<br>
 * - {@link ResourceImage#canLoadImage(String)},<br>
 * - {@link ResourceImage#loadImage(String)},<br>
 * - {@link ResourceImage#loadImage(String, ResourceImage.OutputFormat)},<br>
 * - {@link ResourceImage#loadImage(InputStream, int)},<br>
 * - {@link ResourceImage#loadImage(InputStream, int, ResourceImage.OutputFormat)},<br>
 * - {@link BufferedImage#BufferedImage(int, int)}.
 *
 * @since 2.0
 */
public class ImagePermission extends Permission {

	/**
	 * Creates an image permission with <code>null</code> as name.
	 */
	public ImagePermission() {
		super(null);
		throw new RuntimeException();
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}
}
