/*
 * Java
 *
 * Copyright 2018-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bluetooth;

import ej.annotation.Nullable;

/**
 * The <code>BluetoothUuid</code> class represents the UUID of a service or attribute.
 * <p>
 * UUIDs may be created from a string representing a 128-bit UUID or from an integer containing a 16-bit UUID.
 * <p>
 * A string representation of a UUID may be retrieved by calling the {@link #toString toString()} method of the object.
 * The {@link #equals(Object)} method may be used in order to check if a UUID is equal to an other.
 */
public class BluetoothUuid {

	/**
	 * Creates a UUID from a string.
	 *
	 * @param string
	 *            a string representing a 128-bit UUID.
	 * @throws IllegalArgumentException
	 *             if the given string does not represent a 128-bit UUID.
	 */
	public BluetoothUuid(String string) {
		throw new RuntimeException();
	}

	/**
	 * Creates a UUID from an integer.
	 *
	 * @param value
	 *            an integer representing a 16-bit UUID.
	 */
	public BluetoothUuid(int value) {
		throw new RuntimeException();
	}

	/**
	 * Returns a string representation of this UUID.
	 */
	@Override
	public String toString() {
		throw new RuntimeException();
	}

	/**
	 * Returns whether this UUID is equal to the given object.
	 */
	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}
}
