/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

import ej.annotation.Nullable;

/**
 * The <code>BluetoothAddress</code> class represents the address of a Bluetooth device.
 * <p>
 * Addresses may be created by using the {@link #BluetoothAddress(String, boolean) class constructor} or retrieved by
 * listening to {@link ej.bluetooth.listeners.ConnectionListener#onScanResult(BluetoothAddress, byte[], int) connection
 * events} while {@link BluetoothAdapter#startScanning(BluetoothScanFilter) scanning}.
 * <p>
 * A string representation of an address may be retrieved by calling the {@link #toString toString()} method of the
 * object. The {@link #equals(Object)} method may be used in order to check if an address is equal to an other.
 */
public class BluetoothAddress {

	/**
	 * Creates an address from the given byte array.
	 *
	 * @param bytes
	 *            a byte array containing a Bluetooth address (in big-endian).
	 * @param offset
	 *            the offset of the address in the byte array.
	 * @param isPublic
	 *            true to create a public address, false to create a private address.
	 * @throws ArrayIndexOutOfBoundsException
	 *             if the given byte array is not 6 bytes long.
	 */
	public BluetoothAddress(byte[] bytes, int offset, boolean isPublic) {
		throw new RuntimeException();
	}

	/**
	 * Creates an address from the given string.
	 *
	 * @param string
	 *            a string representing a Bluetooth address (in big-endian).
	 * @param isPublic
	 *            true to create a public address, false to create a private address.
	 * @throws IllegalArgumentException
	 *             if the given string does not represent a Bluetooth address.
	 */
	public BluetoothAddress(String string, boolean isPublic) {
		throw new RuntimeException();
	}

	/**
	 * Writes this address to the given byte array.
	 *
	 * @param buffer
	 *            the buffer to write to (in big-endian).
	 * @param offset
	 *            the index in the buffer to write at.
	 * @throws ArrayIndexOutOfBoundsException
	 *             if the given buffer is not big enough to hold the address.
	 */
	public void getBytes(byte[] buffer, int offset) {
		throw new RuntimeException();
	}

	/**
	 * Returns whether this address is a public address.
	 *
	 * @return true if this address is a public address, false if it is private.
	 */
	public boolean isPublic() {
		throw new RuntimeException();
	}

	/**
	 * Returns a string representation of this address (in big-endian).
	 */
	@Override
	public String toString() {
		throw new RuntimeException();
	}

	/**
	 * Returns whether this address is equal to the given object.
	 */
	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	/**
	 * Returns the hash code value of this address.
	 */
	@Override
	public int hashCode() {
		throw new RuntimeException();
	}
}
