/*
 * Copyright 2018-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.util;

/**
 * Represents a size (width and height).
 * <p>
 * For heap optimization the size is stored as a <code>short</code> and therefore is limited between <code>-32768</code>
 * and <code>32767</code>.
 */
public class Size implements Outlineable {

	private short width;
	private short height;

	/**
	 * Creates a size specifying its values.
	 *
	 * @param width
	 *            the width.
	 * @param height
	 *            the height.
	 */
	public Size(int width, int height) {
		this.width = (short) width;
		this.height = (short) height;
	}

	/**
	 * Creates a size from another size.
	 *
	 * @param size
	 *            the other size.
	 */
	public Size(Size size) {
		this.width = size.width;
		this.height = size.height;
	}

	/**
	 * Gets the width.
	 *
	 * @return the width.
	 */
	public int getWidth() {
		return this.width;
	}

	/**
	 * Sets the width.
	 *
	 * @param width
	 *            the width.
	 */
	public void setWidth(int width) {
		this.width = (short) width;
	}

	/**
	 * Gets the height.
	 *
	 * @return the height.
	 */
	public int getHeight() {
		return this.height;
	}

	/**
	 * Sets the height.
	 *
	 * @param height
	 *            the height.
	 */
	public void setHeight(int height) {
		this.height = (short) height;
	}

	/**
	 * Sets the size.
	 *
	 * @param width
	 *            the width.
	 * @param height
	 *            the height.
	 */
	public void setSize(int width, int height) {
		this.width = (short) width;
		this.height = (short) height;
	}

	@Override
	public void addOutline(int left, int top, int right, int bottom) {
		this.width += left + right;
		this.height += top + bottom;
	}

	@Override
	public void removeOutline(int left, int top, int right, int bottom) {
		this.width -= left + right;
		this.height -= top + bottom;
	}
}
