/*
 * Java
 *
 * Copyright 2019-2024 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Command;

public class SendPasskeyResponseCommand extends Command<Boolean> {

	private final short connHandle;
	private final boolean accept;
	private final int passkey;

	public SendPasskeyResponseCommand(short connHandle, boolean accept, int passkey) {
		this.connHandle = connHandle;
		this.accept = accept;
		this.passkey = passkey;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_SEND_PASSKEY_RESPONSE;
	}

	@Override
	public void writeBody(CommandSender sender) throws IOException {
		sender.sendInt(this.connHandle);
		sender.sendBoolean(this.accept);
		sender.sendInt(this.passkey);
	}

	@Override
	public Boolean readResponseInternal(CommandReader reader) throws IOException {
		return Boolean.valueOf(reader.readInt() == Commands.OK);
	}
}
