/*
 * JACOB - CBOR implementation in Java.
 *
 * Copyright 2016-2019 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 *
 * Licensed under Apache License v2.0.
 */
package ej.cbor;

/**
 *
 */
public class ErrorMessageString extends ErrorMessage {

    @Override
    public String messageAt(int errorCode, Object... args) {
        StringBuilder str = new StringBuilder();
        switch(errorCode) {
            case ErrorMessage.OUTPUT_STREAM_CANNOT_BE_NULL:
                return "OutputStream cannot be null!";
            case ErrorMessage.INVALID_ARRAY_LENGHT:
                return "Invalid array-length!";
            case ErrorMessage.INVALID_MAP_LENGHT:
                return "Invalid length of map!";
            case ErrorMessage.TAG_CANNOT_BE_NEGATIVE:
                return "Invalid tag specification, cannot be negative!";
            case ErrorMessage.INPUT_STREAM_CANNOT_BE_NULL:
                return "InputStream cannot be null!";
            case ErrorMessage.UNEXPECTED_BOOLEAN_VALUE:
                return "Unexpected boolean value: " + getArg(args, 0) + "!";
            case ErrorMessage.INFINITE_LENGTH_BYTE_STRING_NOT_SUPPORTED:
                return "Infinite-length byte strings not supported!";
            case ErrorMessage.STRING_LENGTH_TOO_LONG:
                return "String length too long!";
            case ErrorMessage.INFINITE_LENGHT_TEXT_STRING_NOT_SUPPORTED:
                return "Infinite-length text strings not supported!";
            case ErrorMessage.UNEXPECTED_TYPE:
                return "Unexpected type: " + getArg(args, 0) + ", expected type " + getArg(args, 1) + "!";
            case ErrorMessage.UNEXPECTED_TYPE_TWO_TYPES:
                return "Unexpected type: " + getArg(args, 0) + ", expected type " + getArg(args, 1) + " or " + getArg(args, 2) + "!";
            case ErrorMessage.UNEXPECTED_SUBTYPE:
                return "Unexpected subtype: "+ getArg(args, 0) +", expected: "+ getArg(args, 1) +"!";
            case ErrorMessage.NOT_WELL_FORMED_CBOR_INTEGER:
                return "Not well-formed CBOR integer found, invalid length: " + getArg(args, 0) + "!";
            case ErrorMessage.UNEXPECTED_PAYLOAD_OR_LENGTH:
                return "Unexpected payload/length! Expected "+ getArg(args, 0) +", but got "+ getArg(args, 1) +".";
            case ErrorMessage.NO_PAYLOAD:
                return "no payload";
            case ErrorMessage.ONE_BYTE:
                return "one byte";
            case ErrorMessage.TWO_BYTES:
                return "two bytes";
            case ErrorMessage.FOUR_BYTES:
                return "four bytes";
            case ErrorMessage.EIGHT_BYTES:
                return "eight bytes";
            case ErrorMessage.UNKNOWN:
                return "(unknown)";
            case ErrorMessage.INVALID_MAJOR_TYPE:
                return "Invalid major type!";
            case ErrorMessage.PARAMETERS_CANNOT_BE_NULL:
                return "Parameter cannot be null!";

        }
        return str.toString();
    }

    private String getArg(Object[] args, int i) {
        if (args.length > i) {
            return args[i].toString();
        } else {
            return "undefined";
        }
    }

}
