/*
 * Java
 *
 * Copyright 2010-2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.event.generator;

import ej.microui.event.Event;
import ej.microui.event.EventGenerator;

/**
 * A Keyboard event generator allows key combinations to generate a key code. A keyboard generates the low-level events
 * {@link #KEY_DOWN} and {@link #KEY_UP} and the high-level event {@link #TEXT_INPUT}. The low-level events may be
 * turned on, as they are off by default.<br>
 * <p>
 * Pressing the Q key on a PC/AT US keyboard using a US keyboard layout mapping will produce:
 * <ul>
 * <li>{@link #KEY_DOWN} with Q as letter</li>
 * <li>{@link #TEXT_INPUT} with q as letter</li>
 * <li>{@link #KEY_UP} with Q as letter</li>
 * </ul>
 * If a shift key is pressed while the same Q key is pressed, the following keyboard events will be produced:
 * <ul>
 * <li>{@link #KEY_DOWN} with SHIFT as letter</li>
 * <li>{@link #KEY_DOWN} with Q as letter</li>
 * <li>{@link #TEXT_INPUT} with Q as letter</li>
 * <li>{@link #KEY_UP} with SHIFT as letter</li>
 * <li>{@link #KEY_UP} with Q as letter</li>
 * </ul>
 */
public class Keyboard extends EventGenerator {

	/**
	 * The TEXT_INPUT event action.<br>
	 *
	 * @see Keyboard#getAction(int)
	 */
	public static final int TEXT_INPUT = 0;

	/**
	 * The KEY_DOWN event action.<br>
	 *
	 * @see Keyboard#getAction(int)
	 */
	public static final int KEY_DOWN = 1;

	/**
	 * The KEY_UP event action.<br>
	 *
	 * @see Keyboard#getAction(int)
	 */
	public static final int KEY_UP = 2;

	/**
	 * Keyboards hold a buffer (potentially of size one) that stores the keys before they are used by the application
	 * (key associated to {@link #KEY_UP}, {@link #KEY_DOWN} and {@link #TEXT_INPUT} event). By default, a keyboard will
	 * only send {@link #TEXT_INPUT} events.
	 *
	 * @param bufferSize
	 *            the size of the buffer.
	 * @see #dropOnFull()
	 * @see #onlyTextInput(boolean)
	 */
	public Keyboard(int bufferSize) {
		throw new RuntimeException();
	}

	/**
	 * Subclasses should override this method to specify their policy. By default this method returns <code>false</code>
	 * , which means the oldest data are overwritten by new data. If it returns <code>true</code> new data are dropped
	 * when the pump is full.
	 *
	 * @return <code>true</code> to drop the new data or <code>false</code> to overwrite the oldest data.
	 */
	public boolean dropOnFull() {
		throw new RuntimeException();
	}

	/**
	 * @return {@link Event#KEYBOARD}
	 */
	@Override
	public int getEventType() {
		throw new RuntimeException();
	}

	/**
	 * Specifies whether the {@link #KEY_UP} and {@link #KEY_DOWN} events should be generated. By default they are not
	 * generated.
	 *
	 * @param onlyText
	 *            When true, the low level {@link #KEY_UP} and {@link #KEY_DOWN} are not issued to listener, only
	 *            {@link #TEXT_INPUT} events are sent.
	 */
	public void onlyTextInput(boolean onlyText) {
		throw new RuntimeException();
	}

	/**
	 * Returns the keyboard action held by the keyboard event.
	 *
	 * @param event
	 *            the keyboard event.
	 * @return the keyboard action held by the keyboard event.
	 */
	public int getAction(int event) {
		throw new RuntimeException();
	}

	/**
	 * Gets the next character associated with the specified event.
	 *
	 * @param event
	 *            an event in the standard MicroUI format
	 * @return the next available char associated with the event's type, if none is available 0x0000 is returned.
	 */
	public char getNextChar(int event) {
		throw new RuntimeException();
	}

	/**
	 * Reset the keyboard by flushing all pending characters.
	 *
	 * @see #getNextChar(int)
	 */
	public void reset() {
		throw new RuntimeException();
	}

	/**
	 * Send an keyboard event to the MicroUI application. Default event type are {@link #KEY_UP}, {@link #KEY_DOWN} and
	 * {@link #TEXT_INPUT}.
	 *
	 * @param type
	 *            a type between {@link #KEY_UP}, {@link #KEY_DOWN} and {@link #TEXT_INPUT}.
	 * @param c
	 *            the character to send.
	 */
	public void send(int type, char c) {
		throw new RuntimeException();
	}

}
