/*
 * Copyright 2014-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.motion;

/**
 * Represents a motion function.
 */
public interface Function {

	/**
	 * Returns the value of the function for the given time factor.
	 *
	 * @param t
	 *            the time factor, between 0 and 1.
	 * @return the value of the function for the given time, between 0 and 1.
	 */
	float computeValue(float t);
}
