/*
 * Java
 *
 * Copyright 2018-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.aws.iot;

/**
 * A specific exception relating to AWS Cloud IoT Core services communication
 * errors.
 */
public class AwsIotException extends Exception {

	private static final long serialVersionUID = 1L;

	/**
	 * Constructor.
	 *
	 * @param message the message displayed in the stack trace
	 */
	public AwsIotException(String message) {
		super(message);
	}

	/**
	 * Constructor.
	 *
	 * @param t the cause of the Exception
	 */
	public AwsIotException(Throwable t) {
		super(t);
	}

}
