/*
 * Java
 *
 * Copyright 2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.aws.iot;

/**
 * AwsIotConnectionListener. This provides the connectionLost() callback which is called when the connection is lost
 */
public interface AwsIotConnectionListener {

	/**
	 * This method is called when the connection to the server is lost.
	 *
	 * @param cause
	 *            the reason behind the loss of connection.
	 */
	public void connectionLost(Throwable cause);

}
