/*
 * Copyright 2019 IS2T. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break IS2T warranties on the whole library.
 */
package ej.service;

/**
 * Thrown when a required service is missing.
 *
 * @see ServiceFactory#getRequiredService(Class)
 */
public class MissingServiceException extends RuntimeException {

	private static final long serialVersionUID = 1634308933004829177L;

	/**
	 * Constructs a new missing service exception with the specified detail message. The cause is not initialized, and
	 * may subsequently be initialized by a call to {@link #initCause}.
	 *
	 * @param message
	 *            the detail message (which is saved for later retrieval by the {@link #getMessage()} method).
	 */
	public MissingServiceException(String message) {
		super(message);
	}

}
