/*
 * Java
 *
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.annotation.Nullable;
import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothConnection;
import ej.library.iot.rcommand.bluetooth.BluetoothController;
import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;

public class SendNotificationEndpoint implements Endpoint {

	private final BluetoothController controller;

	private short connHandle;
	private short attributeHandle;
	private @Nullable byte[] value;
	private boolean confirm;

	public SendNotificationEndpoint(BluetoothController controller) {
		this.controller = controller;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_SEND_NOTIFICATION;
	}

	@Override
	public void readRequestBody(CommandReader reader) throws IOException {
		this.connHandle = (short) reader.readInt();
		this.attributeHandle = (short) reader.readInt();
		this.value = reader.readByteArray();
		this.confirm = reader.readBoolean();
	}

	@Override
	public void writeResponseBody(CommandSender sender) throws IOException {
		BluetoothConnection connection = this.controller.getConnection(this.connHandle);
		BluetoothAttribute attribute = this.controller.getLocalAttribute(this.attributeHandle);
		assert (this.value != null);
		if (connection != null && attribute != null && attribute instanceof BluetoothCharacteristic
				&& connection.sendNotification((BluetoothCharacteristic) attribute, this.value, this.confirm)) {
			sender.sendInt(Commands.OK);
		} else {
			sender.sendInt(Commands.ERROR);
		}
	}
}
