/*
 *	Java
 *
 *	Copyright 2015-2016 IS2T. All rights reserved.
 *	IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package ej.microui.display.transform;

import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;

/**
 * This class holds a context in order to perform a free rotation (0 to 360 degrees) on images. The rotation is
 * specified by the center and the angle. The reference point is the image top-left corner. The rotation point is
 * relative to the current translation of the graphics context where the image will be drawn. The image anchor point is
 * relative to the same translation and to the given alignment.
 * <p>
 * To rotate an image on itself, use the following lines:
 * <p>
 * <code>
 * ImageRotation rotation = new ImageRotation();<br>
 * int imageWidth = image.getWidth();<br>
 * int imageHeight = image.getHeight();<br>
 * int rx = x + imageWidth / 2;<br>
 * int ry = y + imageHeight / 2;<br>
 * rotation.setRotationCenter(rx, ry);<br>
 * rotation.setAngle(78);<br>
 * rotation.drawNearestNeighbor(gc, image, rx, ry, GraphicsContext.HCENTER | GraphicsContext.VCENTER);<br>
 * </code>
 * <p>
 * To rotate an image around a circle, use the following lines:
 * <p>
 * <code>
 * ImageRotation rotation = new ImageRotation();<br>
 * rotation.setRotationCenter(rx, ry);<br>
 * for (int i = 0; i &lt; 360; i += 45) {<br>
 * 	rotation.setAngle(i);<br>
 *  rotation.drawBilinear(gc, image, rx - diameter / 2, ry - diameter / 2,<br>
 *  	GraphicsContext.TOP | GraphicsContext.LEFT);<br>
 * }<br>
 * </code>
 * <p>
 * An image rotation instance holds a global state for all drawings. Several instances can be created at the same time.
 * However a default instance is created on MicroUI framework startup and is always available.<br>
 *
 * @since 2.0
 */
public class ImageRotation extends AbstractTransform {

	/**
	 * Default instance created on MicroUI framework startup.
	 */
	public static final ImageRotation Singleton = new ImageRotation();

	/**
	 * Returns the current rotation angle.
	 *
	 * @return the current rotation angle.
	 */
	public int getAngle() {
		throw new RuntimeException();
	}

	/**
	 * Set the new rotation angle.
	 *
	 * @param angle
	 *            the new rotation angle
	 */
	public void setAngle(int angle) {
		throw new RuntimeException();
	}

	/**
	 * Set the new rotation center coordinates.
	 *
	 * @param x
	 *            the x coordinate
	 * @param y
	 *            the y coordinate
	 */
	public void setRotationCenter(int x, int y) {
		throw new RuntimeException();
	}

	/**
	 * Returns the current X coordinate.
	 *
	 * @return the current X coordinate.
	 */
	public int getRotationX() {
		throw new RuntimeException();
	}

	/**
	 * Returns the current Y coordinate.
	 *
	 * @return the current Y coordinate.
	 */
	public int getRotationY() {
		throw new RuntimeException();
	}

	/**
	 * Draws the given {@link Image} applying the current rotation. This method uses the <code>bilinear</code> algorithm
	 * to render the image. This algorithm performs better rendering than <code>nearest neighbor</code> algorithm but it
	 * is slower to apply.
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where to render the drawing.
	 * @param image
	 *            the {@link Image} to draw
	 * @param x
	 *            the x coordinate of the image reference anchor point
	 * @param y
	 *            the y coordinate of the image reference anchor point
	 * @param anchor
	 *            position of the image reference point around the anchor point
	 * @throws NullPointerException
	 *             if @{code image} or @{code gc} is @{code null}
	 * @throws IllegalArgumentException
	 *             if <code>anchor</code> is not a valid value (<code>BASELINE</code> is illegal).
	 * @see #drawNearestNeighbor(GraphicsContext, Image, int, int, int)
	 */
	public void drawBilinear(GraphicsContext gc, Image image, int x, int y, int anchor) {
		throw new RuntimeException();
	}

	/**
	 * Draws the given {@link Image} applying the current rotation. This method uses the <code>nearest neighbor</code>
	 * algorithm to render the image. This algorithm is faster than <code>bilinear</code> algorithm but its rendering is
	 * more simple.
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where render the drawing.
	 * @param image
	 *            the {@link Image} to draw
	 * @param x
	 *            the x coordinate of the image reference anchor point
	 * @param y
	 *            the y coordinate of the image reference anchor point
	 * @param anchor
	 *            position of the image reference point around the anchor point
	 * @throws NullPointerException
	 *             if @{code image} or @{code gc} is @{code null}
	 * @throws IllegalArgumentException
	 *             if <code>anchor</code> is not a valid value (<code>BASELINE</code> is illegal).
	 * @see #drawBilinear(GraphicsContext, Image, int, int, int)
	 */
	public void drawNearestNeighbor(GraphicsContext gc, Image image, int x, int y, int anchor) {
		throw new RuntimeException();
	}

}
