/*
 * Java
 *
 * Copyright 2022-2024 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.microvg.test;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

import ej.microvg.VectorFont;

/**
 * Tests font loading before MicroUI startup.
 */
@SuppressWarnings("nls")
public class TestFontStartup {

	// TODO refine the test precision value when comparing floats if needed (this is an arbitrary value)
	private static final float DELTA = 0.01f;

	/**
	 * Stops MicroUI.
	 */
	@AfterClass
	public static void post() {
		TestUtilities.stopMicroUI();
	}

	/**
	 * Test font loading before MicroUI startup: no error is thrown
	 */
	@Test
	public void testLoadFontBeforeMicroUIStartup() {
		VectorFont f1 = getTestFont();
		float f1Baseline = f1.getBaselinePosition(100);
		Assert.assertEquals("baseline position font 1", Math.round(f1Baseline), 80, DELTA);

		TestUtilities.startMicroUI();

		VectorFont f2 = getTestFont();
		float f2Baseline = f2.getBaselinePosition(100);
		Assert.assertEquals("baseline position font 2", Math.round(f2Baseline), 80, DELTA);

		Assert.assertEquals("baseline positions", f1Baseline, f2Baseline, 0);
	}

	private static VectorFont getTestFont() {
		return VectorFont.loadFont("/fonts/firstfont.ttf");
	}

}
