/*
 * Copyright 2020-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.soar;

import java.io.IOException;
import java.io.InputStream;

/**
 * The Kernel metadata is loaded on demand by a {@link FeatureOptimizer} by requesting {@link InputStream} chunks using
 * {@link #openInputStream(int)} method.<br>
 * Metadata chunks are loaded sequentially, so implementations can assume that at most one {@link InputStream} is open
 * at a time.
 */
public interface KernelMetadataProvider {

	/**
	 * Opens an {@link InputStream} starting at the given metadata offset (0 based). Caller is responsible for closing the
	 * {@link InputStream} before calling this method again.
	 *
	 * @param offset
	 *            the metadata offset where the {@link InputStream} starts.
	 * @return an opened {@link InputStream} ready to read at the given metadata offset.
	 * @throws IOException
	 *             if an IO error occurs when reading from Kernel metadata.
	 */
	public InputStream openInputStream(int offset) throws IOException;

}
