/*
 * Java
 *
 * Copyright 2017-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.sni;

import ej.annotation.Nullable;

/**
 * {@link RuntimeException} subclass that may be thrown from an SNI native using
 * <code>SNI_throwNativeException()</code> function.
 */
public class NativeException extends RuntimeException {


	/**
	 * Constructs a new {@link NativeException} with the specified error code and detail
	 * message.
	 *
	 * @param errorCode the error code. The error code is saved for later retrieval by
	 * the {@link #getErrorCode()} method.
	 *
	 * @param errorMessage the detail message. The detail message is saved for later retrieval
	 * by the {@link #getMessage()} method.
	 */
	public NativeException(int errorCode, String errorMessage){
		throw new RuntimeException();
	}

	/**
	 * Constructs a new {@link NativeException} with the specified error code, detail message and cause.
	 *
	 * @param errorCode the error code. The error code is saved for later retrieval by
	 * the {@link #getErrorCode()} method.
	 *
	 * @param errorMessage the detail message. The detail message is saved for later retrieval
	 * by the {@link #getMessage()} method.
	 *
	 * @param cause the cause (which is saved for later retrieval by the {@link #getCause()} method).
	 * (A <tt>null</tt> value is permitted, and indicates that the cause is nonexistent or unknown.)
	 */
	public NativeException(int errorCode, String errorMessage, @Nullable Throwable cause) {
		throw new RuntimeException();
	}

	/**
	 * Returns the detail message string of this {@link NativeException}.
	 *
	 * @return the detail message string of this {@link NativeException} instance (which may be
	 *         {@code null}).
	 */
	@Override
	@Nullable
	public String getMessage() {
		throw new RuntimeException();
	}

	/**
	 * Returns the error code of this {@link NativeException}.
	 * @return the error code of this {@link NativeException} instance.
	 */
	public int getErrorCode(){
		throw new RuntimeException();
	}
}
