/*
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear.components;

import ej.microui.display.GraphicsContext;

/**
 * Represents a watchface.
 */
public interface Watchface {

	/**
	 * Renders a preview of this watchface.
	 *
	 * @param g
	 *            the graphics context to draw with.
	 * @param x
	 *            the x coordinate of the region to draw in.
	 * @param y
	 *            the y coordinate of the region to draw in.
	 * @param size
	 *            the width and height of the region to draw in.
	 */
	void renderPreview(GraphicsContext g, int x, int y, int size);

	/**
	 * Creates a renderable that renders this watchface.
	 * <p>
	 * This method is called when the watchface is scheduled for imminent rendering. The renderable is then attached
	 * immediately by calling (see {@link Renderable#onAttached()}).
	 *
	 * @return the renderable.
	 */
	Renderable createRenderable();
}
