/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear.framework;

import com.microej.wear.framework.services.ComponentService;
import com.microej.wear.framework.services.DeviceService;
import com.microej.wear.framework.services.ExternalResourceService;
import com.microej.wear.framework.services.FontService;
import com.microej.wear.framework.services.HealthService;
import com.microej.wear.framework.services.NavigationService;
import com.microej.wear.framework.services.TimeService;

import ej.annotation.Nullable;
import ej.bon.Timer;

/**
 * Provides the instance of every Kernel service to the Features.
 */
public class KernelServiceProvider {

	private static @Nullable Timer timer;
	private static @Nullable ComponentService componentService;
	private static @Nullable DeviceService deviceService;
	private static @Nullable ExternalResourceService externalResourceService;
	private static @Nullable FontService fontService;
	private static @Nullable HealthService healthService;
	private static @Nullable NavigationService navigationService;
	private static @Nullable TimeService timeService;

	private KernelServiceProvider() {
		// private constructor
	}

	/**
	 * Returns the timer instance.
	 *
	 * @return the timer instance.
	 */
	public static Timer getTimer() {
		assert (timer != null);
		return timer;
	}

	/**
	 * Returns the component service instance.
	 *
	 * @return the component service instance.
	 */
	public static ComponentService getComponentService() {
		assert (componentService != null);
		return componentService;
	}

	/**
	 * Returns the device service instance.
	 *
	 * @return the device service instance.
	 */
	public static DeviceService getDeviceService() {
		assert (deviceService != null);
		return deviceService;
	}

	/**
	 * Returns the external resources service instance.
	 *
	 * @return the external resources service instance.
	 */
	public static ExternalResourceService getExternalResourceService() {
		assert (externalResourceService != null);
		return externalResourceService;
	}

	/**
	 * Returns the font service instance.
	 *
	 * @return the font service instance.
	 */
	public static FontService getFontService() {
		assert (fontService != null);
		return fontService;
	}

	/**
	 * Returns the health service instance.
	 *
	 * @return the health service instance.
	 */
	public static HealthService getHealthService() {
		assert (healthService != null);
		return healthService;
	}

	/**
	 * Returns the navigation service instance.
	 *
	 * @return the navigation service instance.
	 */
	public static NavigationService getNavigationService() {
		assert (navigationService != null);
		return navigationService;
	}

	/**
	 * Returns the time service instance.
	 *
	 * @return the time service instance.
	 */
	public static TimeService getTimeService() {
		assert (timeService != null);
		return timeService;
	}

	/**
	 * Sets the instance of every service.
	 *
	 * @param timer
	 *            the timer instance.
	 * @param componentService
	 *            the component service instance.
	 * @param navigationService
	 *            the navigation service instance.
	 * @param fontService
	 *            the font service instance.
	 * @param externalResourceService
	 *            the external resource service instance.
	 * @param healthService
	 *            the health service instance.
	 * @param deviceService
	 *            the device service instance.
	 * @param timeService
	 *            the time service instance.
	 */
	public static void setServices(Timer timer, ComponentService componentService, NavigationService navigationService,
			FontService fontService, ExternalResourceService externalResourceService, HealthService healthService,
			DeviceService deviceService, TimeService timeService) {
		KernelServiceProvider.timer = timer;
		KernelServiceProvider.componentService = componentService;
		KernelServiceProvider.navigationService = navigationService;
		KernelServiceProvider.fontService = fontService;
		KernelServiceProvider.externalResourceService = externalResourceService;
		KernelServiceProvider.healthService = healthService;
		KernelServiceProvider.deviceService = deviceService;
		KernelServiceProvider.timeService = timeService;
	}
}
