/*
 * Java
 *
 * Copyright 2018-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.microej.kf.util;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;

/**
 * A {@link Converter} for {@link Long}. This converter creates a clone of the original {@link Long}.
 */
public class LongConverter implements Converter<Long> {

	@Override
	public Long convert(Long arg0, Feature targetOwner) throws IllegalAccessError {
		final long value = arg0.longValue();
		RunnableWithResult<Long> runnable = new RunnableWithResult<Long>() {
			@Override
			public Long runWithResult() {
				return new Long(value);
			}
		};
		Kernel.runUnderContext(targetOwner, runnable);
		return runnable.getResult();
	}

	@Override
	public Class<Long> getType() {
		return Long.class;
	}

}