# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [3.4.0] - 2023-02-13

### Added

- Add getter for `RoundedBackground` border thickness.

### Changed

- Improve `Style` Javadoc: add links to `Alignment`.

### Fixed

- Improve rendering of `RoundedBackground` and `RoundedBorder`.
- Update `RoundedBorder` to work on UI pack since 13.4.1.

## [3.3.1] - 2022-10-18

### Changed

- Do not recompute the layout of a widget that has never been laid out.
- Do not start an animation already started.

## [3.3.0] - 2021-09-14

### Added

- Add a constructor to create a widget specifying its enabled state.
- Add a debug option to highlight the bounds of the widgets and containers.

### Fixed

- Fix RoundedBorder (align correctly, make it symmetric, make it fit the given bounds, simplify code).
- Fix RoundedBackground to make it fit the RoundedBorder perfectly.
- Fix Widget.contains() that returned true for all the pixels on its right and bottom external sides.

## [3.2.1] - 2021-05-10

### Fixed

- Allow to render hidden widgets in an image (introduced in `3.2.0`).
- Ensure that the widget consuming a pointer event (PRESSED or DRAGGED) receives the associated RELEASED event.
- Fix `OverlapRenderPolicy` to render overlapping widgets at the right place when containers have outlines (margin, padding or border).

## [3.2.0] - 2021-03-23

### Added

- Add a method in `Desktop` to get an animator instance.
- Add a method in `Animator` to stop all animations.
- Add root selector.

### Fixed

- Fix widgets having bigger size than available size when using `OptimalDimension` and `FixedDimension` in some cases.
- Do not render hidden widgets (in Container or Desktop).

### Known issues

- Hidden widgets are not rendered when drawing in an image.

## [3.1.3] - 2021-03-02

### Fixed

- Fix animator state when `Display.callOnFlushCompleted()` is called externally just after stopping every animation.
- Throw exception in `Animator.stopAnimation()` if the method is called in an other thread than MicroUI thread or during an animation tick.

## [3.1.2] - 2020-12-21

### Fixed

- Update dependencies to EDC, MicroUI and Drawing.

## [3.1.1] - 2020-11-12

### Changed

- Refactor `FlexibleRectangularBorder` to extend `FlexibleOutline`.
- Refactor `FlexibleRectangularMulticoloredBorder` to extend `FlexibleOutline`.

### Fixed

- Fix render delay after requesting to lay out a widget.

## [3.1.0] - 2020-09-21

### Added

- Add a method in DefaultRenderPolicy to clip and translate a graphics context to a widget's bounds.

### Removed

- Remove dependency to collections library.
- Remove `ej.mwt.animation.Animator` from required types.
- Remove `ej.mwt.animation.Animator` property.

### Fixed

- Fix `equals()` implementation in `NthChildSelector`.
- Avoid embedding the `equals()` and `hashCode()` methods of every embedded class.
- Decrease heap usage and code size of `CascadingStylesheet`.

## [3.0.0] - 2020-08-28

### Changed

- Depends on MicroUI 3.
- Simplify desktop (is not a renderable element anymore).
- Rename Composite class to Container.
- Change lay out process.
- Reorganize packages.

### Added

- Integrate animation framework (from Widgets library).
- Integrate and update style framework (from Widgets library).
- Add methods to order widgets inside a container.
- Add Null annotations.
- Add two different kinds of hooks: when the widget is added to a hierarchy and when the widget is shown on the screen.
- Add the possibility to change the desktop event policy.
- Add the possibility to change the desktop render policy.
- Add alignment management (from MicroUI library).
- Add optimal Dimension (fits widget optimal size).

### Removed

- Remove Panel and Dialog.
- Remove Renderable.
- Remove focus management.
- Remove EventHandler attached to a widget.

## [2.3.1] - 2019-09-10

### Fixed

  - Fix an IndexOutOfBoundsException when showing a panel after a dialog.
  - Fix missing show notification when showing a panel after a dialog.

## [2.3.0] - 2019-02-28

### Changed

  - Use MMM.
  
### Added

  - Set the api dependencies as provided.

## [2.2.5] - 2018-12-05

### Added

  - Add null analysis annotations.

## [2.2.4] - 2018-07-04

### Fixed

  - Fix ArrayIndexOutOfBoundsException thrown when changing focus on composites that don't keep all children in hierarchy.

## [2.2.3] - 2018-03-13

### Fixed

  - Remove absolute bounds computation.
  - Inline some method calls.

## [2.2.2] - 2017-07-03

### Fixed

  - Fix panel child bounds.

## [2.2.1] - 2017-06-23

### Fixed

  - Renderables under the pointer now receive exit event when another renderable captures the pointer session.
  - Desktop now always uses the same mechanism as the widgets to be repaint to avoid possible flickering.
  - Do not repaint widget when calling setEnabled() without changing the current value.
  - Fix dialog hiding (method show may block even after the dialog is hidden).

## [2.2.0] - 2017-02-13

  - Released as an add-on library.

### Added

  - Replace _show_ methods in panel by more explicit ones.
  - Add revalidate method to re-layout a subset of a panel.

### Fixed

  - Do not paint invisible widgets.

## [2.1.11] - 2017-01-04

### Added

  - Optimize flush.

### Fixed

  - Width and height of a invisible widget is set to 0 only when revalidated.

## [2.1.10] - 2016-12-21

### Fixed

  - Call lost focus on a widget when it is effectively unlinked from the panel.

## [2.1.9] - 2016-10-19

### Fixed

  - Call show notify on a widget when it is effectively linked to a panel.

## [2.1.8] - 2016-01-07

### Fixed

  - Fix the refresh of a not active panel(s) when two (or more) panels are shown.

## [2.1.7] - 2016-09-07

### Fixed

  - Check creation of inconsistent hierarchy (widget with several parents).

---  
_Copyright 2018-2023 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  
