# Changelog

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.8.0] - 2025-08-04

### Added
  - Add `ArrayTools.concat()`, `ArrayTools.concatRanges()` and `ArrayTools.equalsRanges()` APIs on byte arrays.
  - Add `StreamUtils.readFully()` and `StreamUtils.skipFully()` APIs.

### Changed
  - Update license file.

### Fixed
  - Fix javadoc for `ArrayTools.grow()`.
  - Fix javadoc for `BitFieldHelper.setBooleanPropertyAtOffset()`.

## [1.7.0] - 2022-04-12

### Added
  - Add `ej.basictool.annotation.Extend` annotation for Class Extender tool.

## [1.6.0] - 2021-02-08

### Changed
  - `ej.basictool.map` classes code updated with all Null Analysis rules enabled. 
  
### Fixed
  - `ej.basictool.map.AbstractWeakPackedMap.keySet()`: `Iterator.next()` could return `null` keys in some cases
    and `Iterator.toArray()` could introduce `null` elements between keys.

## [1.5.0] - 2020-09-10

### Added
  - Add method to get the index of an `int` in an `int` array.
  - Add methods to grow and shrink an array.

### Fixed
  - Remove unnecessary `NullPointerException` comments in javadoc.

## [1.4.0] - 2020-08-14

### Added
  - Add utility method to delay the current thread.
  - Add utility method to handle uncaught exceptions.
  - Add utility methods to check if an array of int contains an int or not.

### Changed
  - Update edc and bon dependencies.
  - Deprecate `ArrayTools.createNewArray()` API.
  - Deprecate `ArrayTools.copy()` APIs.

### Removed
  - Remove dependency to edc-internal.

## [1.3.0] - 2019-10-10

### Changed
  - Convert to MMM project.

### Fixed
  - Avoid concurrency in values() and keySet() iterators.

## [1.2.2] - 2018-12-06

### Added
  - Add null analysis annotations.

## [1.2.1] - 2018-10-19

### Fixed
  - Fix concurrency issues (that result in exceptions).

## [1.2.0] - 2018-06-06

### Added
  - Add packed maps with a weak key.
  - Add values() method.

### Fixed
  - Fix concurrency issues (that result in inconsistencies or exceptions).

## [1.1.1] - 2018-06-04

### Fixed
  - Cannot retrieve an entry that have been put before in packed maps.

## [1.1.0] - 2018-05-24

### Added
  - Add the possibility to remove at a specific index in ArrayTools.
  - Add packed maps.

## [1.0.0] - 2017-08-29

### Added
  - Initial revision.

---
_Copyright 2016-2025 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  
