# Overview

HOKA is a tiny extensible web server for embedded devices.

# Usage

HOKA 8.3.X is released. check the [CHANGELOG](CHANGELOG.md)

`<dependency org="ej.library.iot" name="hoka" rev="8.3.X"/>`

## Getting Started
Add ivy dependency to your MicroEJ application

`<dependency org="ej.library.iot" name="hoka" rev="8.3.X"/>`

```java
        public class MyServer {

          public static void main(String[] args) throws IOException {

				HttpServer http = HttpServer.builder()
						.port(8080) 
						.simultaneousConnections(4)
						.workerCount(4)
						.build();

              http.get("/hello", new RequestHandler() {

                @Override
                public void process(HTTPRequest request, HTTPResponse response) {
                  response.setData("Hello world!");
                }
              });

              http.start();

          }
        }
```

Run the application and check the result at `http://localhost:8080/hello`

## How to build this project

* Clone this repository locally
* Import the project to MicroEJ Studio. File > Import > General > Existing project into workspace
* Right Click on the project > Build Module


PS: Unit tests are deactivated by default. To activate them, open `module.ant` file and change the property `skip.tests` from `false` to `true`.


# Documentation

The full documentation can be found here [documentation](documentation.rst).

# Requirements
N/A
# Dependencies
N/A
# Source
N/A
# Restrictions
N/A

---  
_Copyright 2017-2021 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  
