# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [2.0.0] - 2025-09-23

### Added

- Add `ResourceService`.
- Add `onPreviewAttached()` and `onPreviewDetached()` methods in `Watchface`.
- Add `onIconAttached()` and `onIconDetached()` methods in `Activity`.
- Add `onIconAttached()` and `onIconDetached()` methods in `ComplicationDataSource`.
- Add `getActivities()` and `getWatchfaces()` methods in `ComponentService`.
- Add `getMonospaceFont()` and `getSemiBoldFont()` methods in `FontService`.
- Add `getExternalResourcePath()` method in `ExternalResourceService`.

### Changed

- Update SDK to 1.3.1.
- Move `TimeService.ConfigurationListener` to its own class.
- Replace `NavigationService` by `Navigator` component.
- Replace Kernel runtime implementation by stub implementation in every method of `KernelServiceProvider`.

### Removed

- Remove `setTimeConfiguration()` method in `TimeService`.
- Remove `setServices()` method in `KernelServiceProvider`.

## [1.1.0] - 2025-04-29

### Added

- Add `getDeviceName()` method in `DeviceService`.
- Add `getDeviceBluetoothAddress()` method in `DeviceService`.

## [1.0.0] - 2025-02-26

### Added

- Add `ExternalResourceService.Writer` interface.
- Add `deleteExternalResource()` method in `ExternalResourceService`.

### Changed

- Change signature and behavior of `createExternalResource()` and `createExternalImage()` methods
  in `ExternalResourceService`.
- Rename `ExternalResourceService.Format` into `ExternalResourceService.ImageFormat`.

### Removed

- Remove `getSNIContext()` method in `ExternalResourceService.Format`.
- Remove `deleteExternalResources()` method in `ExternalResourceService`.

## [0.11.0] - 2025-02-07

### Added

- Add `Renderable` component interface.
- Add `createRenderable()` method in `Activity` and `Watchface`.
- Add `handleEvent()` method in `NavigationService`.

### Removed

- Remove `show()` method in `Activity` and `Watchface`.
- Remove `hideActivity()`, `showActivityLauncher()` and `showWatchfacePicker()` methods in `NavigationService`.

## [0.10.0] - 2024-12-12

### Added

- Add methods for local time management in `TimeService`.

### Changed

- Rename module to `wear-services`.
- Rename package hierarchy to remove `framework`.

### Removed

- Remove `getCurrentZoneOffset()` method in `TimeService`.

## [0.9.1] - 2024-10-11

### Changed

- Change license to SDK/BSD Dual License.

## [0.9.0] - 2024-10-03

### Added

- Add component interfaces: `Activity`, `ComplicationDataSource` and `Watchface`.
- Add service interfaces: `ComponentService`, `DeviceService`, `ExternalResourceService`, `FontService`,
  `HealthService`, `NavigationService` and `TimeService`.
- Add `KernelServiceProvider`.

---
_Copyright 2024-2025 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._
