
# Overview

MicroEJ C Component: `com.microej.clibrary.llimpl#microui`.

This component implements some Low-Level API (LLAPI) of MicroUI-3.x. 
Refer to the VEE Porting Guide > Graphics User Interface > C Module to have more information on this module.

# MicroEJ UI Pack

This compoment is MicroEJ UI Pack dependent: it is compatible with a one or several MicroEJ UI Pack versions. The following table illustrates the compatibility:


| Component     | MicroEJ UI Pack   | Comment                   |
| ------------- | ----------------- | ------------------------- |
| 4.0.0         | [14.0.0 - 15.0.0[ | buffer refresh strategies |
| [3.1.0-3.1.1] | [13.7.0 - 14.0.0[ | free image resources      |
| 3.0.0         | [13.5.0 - 13.7.0[ | multi output formats      |
| [2.0.0-2.0.1] | [13.3.0 - 13.5.0[ | adjust with new LLUI API  |
| [1.1.0-1.1.1] | [13.1.0 - 13.3.0[ | add logger and heap       |
| [1.0.1-1.0.3] | [13.0.0 - 13.1.0[ |                           |
| 1.0.0         | n/a               | deprecated                |

> note: this component is useless (and not compatible) for the MicroEJ UI Packs before version 13.0.0.

# Usage

1. Add the following line to your `module.ivy`:

    <dependency org="com.microej.clibrary.llimpl" name="microui" rev="4.0.1"/>

2. Follow the **Usage** chapters of each component part (see VEE Porting Guide > Graphics User Interface > C Module)

# Migration Guide

The migration guides are described in the VEE Porting Guide > Graphical User Interface > Migration Guide. 

# Requirements

None.

# Dependencies

_All dependencies are retrieved transitively by MicroEJ Module Manager_.

# Source

N/A

# Restrictions

None.

---
_Copyright 2020-2024 MicroEJ Corp. All rights reserved._  
_Use of this source code is governed by a BSD-style license that can be found with this software._  