# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## Since 14.1.0

Since the version **14.1.0**, refer to the [UI Pack's changelog](https://docs.microej.com/en/latest/VEEPortingGuide/uiChangeLog.html), section `C Module MicroUI`.

## [14.5.1] - 2025-10-13

- Compatible with MicroEJ UI Pack 14.5.1.

## [14.5.0] - 2025-10-07

- Compatible with MicroEJ UI Pack 14.5.0.

## [14.4.2] - 2025-05-20

- Compatible with MicroEJ UI Pack 14.4.2.

## [14.4.1] - 2025-03-13

- Compatible with MicroEJ UI Pack 14.4.1.

## [14.4.0] - 2025-03-07

- Compatible with MicroEJ UI Pack 14.4.0.

## [14.3.3] - 2025-02-18

- Compatible with MicroEJ UI Pack 14.3.3.

## [14.3.2] - 2025-02-10

- Compatible with MicroEJ UI Pack 14.3.2.

## [14.3.1] - 2025-01-31

- Compatible with MicroEJ UI Pack 14.3.1.

## [14.3.0] - 2025-01-24

- Compatible with MicroEJ UI Pack 14.3.0.

## [14.2.0] - 2024-11-18

- Compatible with MicroEJ UI Pack 14.2.0.

## [14.1.1] - 2024-10-17

- Compatible with MicroEJ UI Pack 14.1.1.

## [14.1.0] - 2024-10-09

- Compatible with MicroEJ UI Pack 14.1.0.

## [14.0.3] - 2024-10-01

- Compatible with MicroEJ UI Pack 14.0.3.
- Align the version numbering to match the version number the MicroEJ UI Pack.

## [4.1.0] - 2024-07-19

- Compatible with MicroEJ UI Pack 14.0.x.

### Added

- Add `ui_color.h` that provides macros to manipulate the color channels of the ARGB8888 pixel format.

### Fixed

- Fix copying regions from a buffer to the same buffer.

## [4.0.1] - 2024-04-09

- Compatible with MicroEJ UI Pack 14.0.x.

### Changed

- Homogenize the notions of back and front buffers.

### Fixed

- Disable the clip before calling `UI_DISPLAY_BRS_restore()`.

## [4.0.0] - 2024-02-14

- Compatible with MicroEJ UI Pack 14.0.x.

### Added

- Add the possibility to log external events in the MicroUI event group.
- Add the buffer refresh strategies (BRS) Legacy, Single and Predraw.
- Add some utility functions to manipulate rectangles and collections of rectangles.

### Changed

- Make the C Module compatible with UI pack 14.0.0 and higher.

## [3.1.1] - 2023-10-25

- Compatible with MicroEJ UI Pack 13.7.x.

### Changed

- Update the license file.

## [3.1.0] - 2023-10-23

- Compatible with MicroEJ UI Pack 13.7.x.

### Added

- Add the compatibility with UI pack 13.7.0 and higher: can free third-party resources associated with images.

### Fixed

- Fix some comments.

## [3.0.0] - 2023-05-03

- Compatible with MicroEJ UI Pack 13.5.x and 13.6.x

### Added

- Add support for multiple Graphics Context output formats.
- Add support for multiple Image input formats.
- Add stub implementations for all MicroUI and Drawing libraries algorithms.

### Changed

- Make the C Module compatible with UI pack 13.5.0 and higher.

## [2.0.1] - 2022-12-16

- Compatible with MicroEJ UI Pack 13.3.x and 13.4.x

### Changed

- Do not draw thick shapes when thickness and fade are equal to zero.

## [2.0.0] - 2022-08-31

- Compatible with MicroEJ UI Pack 13.3.x and 13.4.x

### Changed

- Improve `drawImage`: identify faster use cases (copy an image and draw a region with overlap).
- Use new MicroEJ UI Pack 13.3.0 API: `UI_DRAWING_copyImage` and `UI_DRAWING_drawRegion`.
- Use new MicroUI's native functions declaration (not backward compatible).

## [1.1.1] - 2022-04-27

- Compatible with MicroEJ UI Pack 13.1.x and 13.2.x.

### Fixed

- Fix the license and copyrights: use BSD License.
- Fix Misra rules.

## [1.1.0] - 2021-07-16

- Compatible with MicroEJ UI Pack 13.1.x and 13.2.x.

### Added

- Add MicroUI events logger.
- Add MicroUI images heap allocator.

### Fixed

- Fix comments in `LLUI_PAINTER_impl.c` and `LLDW_PAINTER_impl.c`.
- Ignore a drawing when at least one scaling factor is equal to zero.

## [1.0.3] - 2020-12-08

- Compatible with MicroEJ UI Pack 13.0.x.

### Fixed

- Fix missing license file.

## [1.0.2] - 2020-09-02

- Compatible with MicroEJ UI Pack 13.0.x.

### Changed

- Fix artifact organization.

## [1.0.1] - 2020-07-28

- Compatible with MicroEJ UI Pack 13.0.x.

### Changed

- Fix MISRA C 2004 rule 13.3.
- Rename some parameters.
- Clamp user's alpha value instead of throwing an exception.
- Rename readPixel in writePixel.

## [1.0.0] - 2020-04-09

- Initial revision (deprecated version).
- Implements `LLGRAPHICS_impl.h` and `LLGRAPHICS_EXT_impl.h` functions (MicroUI native functions).
- Log all drawings.
- Dispatch all drawings to the implementation of `DRAWING_impl.h`

---
_Copyright 2020-2025 MicroEJ Corp. All rights reserved._\
_MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms._
