/*
 * Java
 *
 * Copyright 2019-2024 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Command;

public class SendPairRequestCommand extends Command<Boolean> {

	private final short connHandle;

	public SendPairRequestCommand(short connHandle) {
		this.connHandle = connHandle;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_SEND_PAIR_REQUEST;
	}

	@Override
	public void writeBody(CommandSender sender) throws IOException {
		sender.sendInt(this.connHandle);
	}

	@Override
	public Boolean readResponseInternal(CommandReader reader) throws IOException {
		return Boolean.valueOf(reader.readInt() == Commands.OK);
	}
}
