/*
 * Java
 *
 * Copyright 2011-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bon;

/**
 * ReferenceQueue represents a queue of EnqueuedWeakReference. The system is responsible
 * for adding such EnqueuedWeakReference into the ReferenceQueue.<br>
 * There are two ways to retrieve and remove an element from the queue.<br>
 * - {@link #poll()} : returns null if the queue is empty, otherwise returns and removes the first
 * element of the FIFO queue.<br>
 * - {@link #remove()} : blocks the current thread until the queue becomes not empty.
 * returns and removes the first element of the FIFO queue.<br>
 * @see EnqueuedWeakReference
 */
public final class ReferenceQueue {

	/**
	 * */
	public ReferenceQueue(){
		throw new RuntimeException();
	}

	/**
	 * Queries the queue and returns and removes the first element of the queue.
	 * If the queue is empty, returns <code>null</code>.
	 * @return EnqueuedWeakReference or <code>null</code>
	 */
	public EnqueuedWeakReference poll(){
		throw new RuntimeException();
	}

	/**
	 * Queries the queue, returns and removes the first element of the queue.
	 * If the queue is empty, blocks the current thread until the queue gets
	 * at least one element (automatically added by the system).
	 * @return EnqueuedWeakReference
	 * @throws InterruptedException if the thread is interrupted
	 */
	public EnqueuedWeakReference remove() throws InterruptedException{
		throw new RuntimeException();
	}
}