package java.lang;

import ej.annotation.Nullable;

/**
 * Thrown to indicate that a method has been passed an illegal or inappropriate argument.
 *
 * @see java.lang.Thread#setPriority(int)
 */
public class IllegalArgumentException extends RuntimeException {
	/**
	 * Constructs an <code>IllegalArgumentException</code> with no detail message.
	 */
	public IllegalArgumentException() {
		throw new RuntimeException();
	}

	/**
	 * Constructs an <code>IllegalArgumentException</code> with the specified detail message.
	 *
	 * @param s
	 *        the detail message.
	 */
	public IllegalArgumentException(String s) {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new exception with the specified detail message and cause.
	 *
	 * <p>
	 * Note that the detail message associated with <code>cause</code> is <i>not</i> automatically
	 * incorporated in this exception's detail message.
	 *
	 * @param message
	 *        the detail message (which is saved for later retrieval by the
	 *        {@link Throwable#getMessage()} method).
	 * @param cause
	 *        the cause (which is saved for later retrieval by the {@link Throwable#getCause()} method).
	 *        (A <code>null</code> value is permitted, and indicates that the cause is nonexistent or
	 *        unknown.)
	 */
	public IllegalArgumentException(String message, @Nullable Throwable cause) {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new exception with the specified cause and a detail message of
	 * <code>(cause==null ? null : cause.toString())</code> (which typically contains the class and detail
	 * message of <code>cause</code>). This constructor is useful for exceptions that are little more than
	 * wrappers for other throwables.
	 *
	 * @param cause
	 *        the cause (which is saved for later retrieval by the {@link Throwable#getCause()} method).
	 *        (A <code>null</code> value is permitted, and indicates that the cause is nonexistent or
	 *        unknown.)
	 */
	public IllegalArgumentException(@Nullable Throwable cause) {
		throw new RuntimeException();
	}

}
