package java.lang;

import ej.annotation.Nullable;

/**
 * The class {@code Exception} and its subclasses are a form of {@code Throwable} that indicates
 * conditions that a reasonable application might want to catch.
 *
 * <p>
 * The class {@code Exception} and any subclasses that are not also subclasses of
 * {@link RuntimeException} are <em>checked exceptions</em>. Checked exceptions need to be declared
 * in a method or constructor's {@code throws} clause if they can be thrown by the execution of the
 * method or constructor and propagate outside the method or constructor boundary.
 *
 */
public class Exception extends Throwable {

	/**
	 * Constructs a new exception with {@code null} as its detail message. The cause is not initialized,
	 * and may subsequently be initialized by a call to {@link #initCause}.
	 */
	public Exception() {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new exception with the specified detail message. The cause is not initialized, and
	 * may subsequently be initialized by a call to {@link #initCause}.
	 *
	 * @param message
	 *        the detail message. The detail message is saved for later retrieval by the
	 *        {@link #getMessage()} method.
	 */
	public Exception(String message) {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new exception with the specified detail message and cause.
	 * <p>
	 * Note that the detail message associated with {@code cause} is <i>not</i> automatically
	 * incorporated in this exception's detail message.
	 *
	 * @param message
	 *        the detail message (which is saved for later retrieval by the {@link #getMessage()}
	 *        method).
	 * @param cause
	 *        the cause (which is saved for later retrieval by the {@link #getCause()} method). (A
	 *        <code>null</code> value is permitted, and indicates that the cause is nonexistent or unknown.)
	 */
	public Exception(String message, @Nullable Throwable cause) {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new exception with the specified cause and a detail message of
	 * <code>(cause==null ? null : cause.toString())</code> (which typically contains the class and detail
	 * message of <code>cause</code>). This constructor is useful for exceptions that are little more than
	 * wrappers for other throwables.
	 *
	 * @param cause
	 *        the cause (which is saved for later retrieval by the {@link #getCause()} method). (A
	 *        <code>null</code> value is permitted, and indicates that the cause is nonexistent or unknown.)
	 */
	public Exception(@Nullable Throwable cause) {
		throw new RuntimeException();
	}

}
