package java.lang;

import ej.annotation.Nullable;

/**
 * The {@code Character} class wraps a value of the primitive type {@code char} in an object. An
 * object of type {@code Character} contains a single field whose type is {@code char}.
 * <p>
 * In addition, this class provides several methods for determining a character's category
 * (lowercase letter, digit, etc.) and for converting characters from uppercase to lowercase and
 * vice versa.
 * <p>
 * Character information is based on the Unicode Standard, version 6.0.0.
 */
public final class Character implements java.io.Serializable, Comparable<Character> {

	/**
	 * The maximum radix available for conversion to and from strings. The constant value of this field
	 * is the largest value permitted for the radix argument in radix-conversion methods such as the
	 * {@code digit} method, the {@code forDigit} method, and the {@code toString} method of class
	 * {@code Integer}.
	 *
	 * @see Character#digit(char, int)
	 * @see Character#forDigit(int, int)
	 * @see Integer#toString(int, int)
	 * @see Integer#valueOf(String)
	 */
	public static final int MAX_RADIX = 36;

	/**
	 * The constant value of this field is the largest value of type {@code char},
	 * {@code '\u005CuFFFF'}.
	 */
	public static final char MAX_VALUE = '\uffff';

	/**
	 * The minimum radix available for conversion to and from strings. The constant value of this field
	 * is the smallest value permitted for the radix argument in radix-conversion methods such as the
	 * {@code digit} method, the {@code forDigit} method, and the {@code toString} method of class
	 * {@code Integer}.
	 *
	 * @see Character#digit(char, int)
	 * @see Character#forDigit(int, int)
	 * @see Integer#toString(int, int)
	 * @see Integer#valueOf(String)
	 */
	public static final int MIN_RADIX = 2;

	/**
	 * The constant value of this field is the smallest value of type {@code char},
	 * {@code '\u005Cu0000'}.
	 */
	public static final char MIN_VALUE = '\u0000';

	/**
	 * The number of bits used to represent a <code>char</code> value in unsigned binary form, constant
	 * {@code 16}.
	 */
	public static final int SIZE = 16;

	/**
	 * Constructs a newly allocated {@code Character} object that represents the specified {@code char}
	 * value.
	 *
	 * @param value
	 *        the value to be represented by the {@code Character} object.
	 */
	public Character(char value) {
		throw new RuntimeException();
	}

	/**
	 * Compares two {@code char} values numerically. The value returned is identical to what would be
	 * returned by:
	 *
	 * <pre>
	 * Character.valueOf(x).compareTo(Character.valueOf(y))
	 * </pre>
	 *
	 * @param x
	 *        the first {@code char} to compare
	 * @param y
	 *        the second {@code char} to compare
	 * @return the value {@code 0} if {@code x == y}; a value less than {@code 0} if {@code x < y}; and
	 *         a value greater than {@code 0} if {@code x > y}
	 */
	public static int compare(char x, char y) {
		throw new RuntimeException();
	}

	/**
	 * Returns the numeric value of the character ch in the specified radix.
	 * @param ch the character to be converted.
	 * @param radix the radix.
	 * @return the numeric value represented by the character in the specified radix.
	 */
	public static int digit(char ch, int radix) {
		throw new RuntimeException();
	}

	/**
	 * Determines the character representation for a specific digit in the specified radix. If the value
	 * of {@code radix} is not a valid radix, or the value of {@code digit} is not a valid digit in the
	 * specified radix, the null character ({@code '\u005Cu0000'}) is returned.
	 * <p>
	 * The {@code radix} argument is valid if it is greater than or equal to {@code MIN_RADIX} and less
	 * than or equal to {@code MAX_RADIX}. The {@code digit} argument is valid if
	 * {@code 0 <= digit < radix}.
	 * <p>
	 * If the digit is less than 10, then {@code '0' + digit} is returned. Otherwise, the value
	 * {@code 'a' + digit - 10} is returned.
	 *
	 * @param digit
	 *        the number to convert to a character.
	 * @param radix
	 *        the radix.
	 * @return the {@code char} representation of the specified digit in the specified radix.
	 * @see Character#MIN_RADIX
	 * @see Character#MAX_RADIX
	 * @see Character#digit(char, int)
	 */
	public static char forDigit(int digit, int radix) {
		throw new RuntimeException();
	}

	/**
	 * Determines if the specified character is a digit.
	 * <p>
	 * Some Unicode character ranges that contain digits:
	 * <ul>
	 * <li>{@code '\u005Cu0030'} through {@code '\u005Cu0039'}, ISO-LATIN-1 digits ({@code '0'} through
	 * {@code '9'})
	 * <li>{@code '\u005Cu0660'} through {@code '\u005Cu0669'}, Arabic-Indic digits
	 * <li>{@code '\u005Cu06F0'} through {@code '\u005Cu06F9'}, Extended Arabic-Indic digits
	 * <li>{@code '\u005Cu0966'} through {@code '\u005Cu096F'}, Devanagari digits
	 * <li>{@code '\u005CuFF10'} through {@code '\u005CuFF19'}, Fullwidth digits
	 * </ul>
	 *
	 * Many other character ranges contain digits as well.
	 *
	 * @param ch
	 *        the character to be tested.
	 * @return {@code true} if the character is a digit; {@code false} otherwise.
	 * @see Character#digit(char, int)
	 * @see Character#forDigit(int, int)
	 */
	public static boolean isDigit(char ch) {
		throw new RuntimeException();
	}

	/**
	 * Determines if the specified character is an ISO control character. A character is considered to
	 * be an ISO control character if its code is in the range {@code '\u005Cu0000'} through
	 * {@code '\u005Cu001F'} or in the range {@code '\u005Cu007F'} through {@code '\u005Cu009F'}.
	 *
	 * @param ch
	 *        the character to be tested.
	 * @return {@code true} if the character is an ISO control character; {@code false} otherwise.
	 *
	 * @see Character#isSpaceChar(char)
	 * @see Character#isWhitespace(char)
	 */
	public static boolean isISOControl(char ch) {
		throw new RuntimeException();
	}

	/**
	 * Determines if the specified character is a lowercase character.
	 * <p>
	 * A character is lowercase if its general category type, provided by {@code Character.getType(ch)},
	 * is {@code LOWERCASE_LETTER}, or it has contributory property Other_Lowercase as defined by the
	 * Unicode Standard.
	 * <p>
	 * The following are examples of lowercase characters:
	 * <blockquote>
	 *
	 * <pre>
	 * a b c d e f g h i j k l m n o p q r s t u v w x y z
	 * '&#92;u00DF' '&#92;u00E0' '&#92;u00E1' '&#92;u00E2' '&#92;u00E3' '&#92;u00E4' '&#92;u00E5' '&#92;u00E6'
	 * '&#92;u00E7' '&#92;u00E8' '&#92;u00E9' '&#92;u00EA' '&#92;u00EB' '&#92;u00EC' '&#92;u00ED' '&#92;u00EE'
	 * '&#92;u00EF' '&#92;u00F0' '&#92;u00F1' '&#92;u00F2' '&#92;u00F3' '&#92;u00F4' '&#92;u00F5' '&#92;u00F6'
	 * '&#92;u00F8' '&#92;u00F9' '&#92;u00FA' '&#92;u00FB' '&#92;u00FC' '&#92;u00FD' '&#92;u00FE' '&#92;u00FF'
	 * </pre>
	 *
	 * </blockquote>
	 * <p>
	 * Many other Unicode characters are lowercase too.
	 *
	 * @param ch
	 *        the character to be tested.
	 * @return {@code true} if the character is lowercase; {@code false} otherwise.
	 * @see Character#isLowerCase(char)
	 * @see Character#toLowerCase(char)
	 */
	public static boolean isLowerCase(char ch) {
		throw new RuntimeException();
	}

	/**
	 * Determines if the specified character is a Unicode space character. A character is considered to
	 * be a space character if and only if it is specified to be a space character by the Unicode
	 * Standard. This method returns true if the character's general category type is any of the
	 * following:
	 * <ul>
	 * <li>{@code SPACE_SEPARATOR}
	 * <li>{@code LINE_SEPARATOR}
	 * <li>{@code PARAGRAPH_SEPARATOR}
	 * </ul>
	 *
	 * @param ch
	 *        the character to be tested.
	 * @return {@code true} if the character is a space character; {@code false} otherwise.
	 * @see Character#isWhitespace(char)
	 */
	public static boolean isSpaceChar(char ch) {
		throw new RuntimeException();
	}

	/**
	 * Determines if the specified character is an uppercase character.
	 * <p>
	 * A character is uppercase if its general category type, provided by {@code Character.getType(ch)},
	 * is {@code UPPERCASE_LETTER}. or it has contributory property Other_Uppercase as defined by the
	 * Unicode Standard.
	 * <p>
	 * The following are examples of uppercase characters:
	 * <blockquote>
	 *
	 * <pre>
	 * A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
	 * '&#92;u00C0' '&#92;u00C1' '&#92;u00C2' '&#92;u00C3' '&#92;u00C4' '&#92;u00C5' '&#92;u00C6' '&#92;u00C7'
	 * '&#92;u00C8' '&#92;u00C9' '&#92;u00CA' '&#92;u00CB' '&#92;u00CC' '&#92;u00CD' '&#92;u00CE' '&#92;u00CF'
	 * '&#92;u00D0' '&#92;u00D1' '&#92;u00D2' '&#92;u00D3' '&#92;u00D4' '&#92;u00D5' '&#92;u00D6' '&#92;u00D8'
	 * '&#92;u00D9' '&#92;u00DA' '&#92;u00DB' '&#92;u00DC' '&#92;u00DD' '&#92;u00DE'
	 * </pre>
	 *
	 * </blockquote>
	 * <p>
	 * Many other Unicode characters are uppercase too.
	 * <p>
	 *
	 * @param ch
	 *        the character to be tested.
	 * @return {@code true} if the character is uppercase; {@code false} otherwise.
	 * @see Character#isLowerCase(char)
	 * @see Character#toUpperCase(char)
	 */
	public static boolean isUpperCase(char ch) {
		throw new RuntimeException();
	}

	/**
	 * Determines if the specified character is white space according to Java. A character is a Java
	 * whitespace character if and only if it satisfies one of the following criteria:
	 * <ul>
	 * <li>It is a Unicode space character ({@code SPACE_SEPARATOR}, {@code LINE_SEPARATOR}, or
	 * {@code PARAGRAPH_SEPARATOR}) but is not also a non-breaking space ({@code '\u005Cu00A0'},
	 * {@code '\u005Cu2007'}, {@code '\u005Cu202F'}).
	 * <li>It is {@code '\u005Ct'}, U+0009 HORIZONTAL TABULATION.
	 * <li>It is {@code '\u005Cn'}, U+000A LINE FEED.
	 * <li>It is {@code '\u005Cu000B'}, U+000B VERTICAL TABULATION.
	 * <li>It is {@code '\u005Cf'}, U+000C FORM FEED.
	 * <li>It is {@code '\u005Cr'}, U+000D CARRIAGE RETURN.
	 * <li>It is {@code '\u005Cu001C'}, U+001C FILE SEPARATOR.
	 * <li>It is {@code '\u005Cu001D'}, U+001D GROUP SEPARATOR.
	 * <li>It is {@code '\u005Cu001E'}, U+001E RECORD SEPARATOR.
	 * <li>It is {@code '\u005Cu001F'}, U+001F UNIT SEPARATOR.
	 * </ul>
	 *
	 * @param ch
	 *        the character to be tested.
	 * @return {@code true} if the character is a Java whitespace character; {@code false} otherwise.
	 * @see Character#isSpaceChar(char)
	 */
	public static boolean isWhitespace(char ch) {
		throw new RuntimeException();
	}

	/**
	 * Converts the character argument to lowercase using case mapping information from the UnicodeData
	 * file.
	 * <p>
	 * Note that {@code Character.isLowerCase(Character.toLowerCase(ch))} does not always return
	 * {@code true} for some ranges of characters, particularly those that are symbols or ideographs.
	 *
	 * <p>
	 * In general, {@link String#toLowerCase()} should be used to map characters to lowercase.
	 * {@code String} case mapping methods have several benefits over {@code Character} case mapping
	 * methods. {@code String} case mapping methods can perform locale-sensitive mappings,
	 * context-sensitive mappings, and 1:M character mappings, whereas the {@code Character} case
	 * mapping methods cannot.
	 *
	 * @param ch
	 *        the character to be converted.
	 * @return the lowercase equivalent of the character, if any; otherwise, the character itself.
	 * @see Character#isLowerCase(char)
	 * @see String#toLowerCase()
	 */
	public static char toLowerCase(char ch) {
		throw new RuntimeException();
	}

	/**
	 * Returns a {@code String} object representing the specified {@code char}. The result is a string
	 * of length 1 consisting solely of the specified {@code char}.
	 *
	 * @param c
	 *        the {@code char} to be converted
	 * @return the string representation of the specified {@code char}
	 */
	public static String toString(char c) {
		throw new RuntimeException();
	}

	/**
	 * Converts the character argument to uppercase using case mapping information from the UnicodeData
	 * file.
	 * <p>
	 * Note that {@code Character.isUpperCase(Character.toUpperCase(ch))} does not always return
	 * {@code true} for some ranges of characters, particularly those that are symbols or ideographs.
	 *
	 * <p>
	 * In general, {@link String#toUpperCase()} should be used to map characters to uppercase.
	 * {@code String} case mapping methods have several benefits over {@code Character} case mapping
	 * methods. {@code String} case mapping methods can perform locale-sensitive mappings,
	 * context-sensitive mappings, and 1:M character mappings, whereas the {@code Character} case
	 * mapping methods cannot.
	 *
	 * @param ch
	 *        the character to be converted.
	 * @return the uppercase equivalent of the character, if any; otherwise, the character itself.
	 * @see Character#isUpperCase(char)
	 * @see String#toUpperCase()
	 */
	public static char toUpperCase(char ch) {
		throw new RuntimeException();
	}

	/**
	 * Returns a <code>Character</code> instance representing the specified <code>char</code> value. If a new
	 * <code>Character</code> instance is not required, this method should generally be used in preference
	 * to the constructor {@link #Character(char)}, as this method is likely to yield significantly
	 * better space and time performance by caching frequently requested values.
	 *
	 * This method will always cache values in the range {@code '\u005Cu0000'} to {@code '\u005Cu007F'},
	 * inclusive, and may cache other values outside of this range.
	 *
	 * @param c
	 *        a char value.
	 * @return a <code>Character</code> instance representing <code>c</code>.
	 */
	public static Character valueOf(char c) {
		throw new RuntimeException();
	}

	/**
	 * Returns the value of this {@code Character} object.
	 *
	 * @return the primitive {@code char} value represented by this object.
	 */
	public char charValue() {
		throw new RuntimeException();
	}

	/**
	 * Compares two {@code Character} objects numerically.
	 *
	 * @param anotherCharacter
	 *        the {@code Character} to be compared.
	 *
	 * @return the value {@code 0} if the argument {@code Character} is equal to this {@code Character};
	 *         a value less than {@code 0} if this {@code Character} is numerically less than the
	 *         {@code Character} argument; and a value greater than {@code 0} if this {@code Character}
	 *         is numerically greater than the {@code Character} argument (unsigned comparison). Note
	 *         that this is strictly a numerical comparison; it is not locale-dependent.
	 */
	@Override
	public int compareTo(Character anotherCharacter) {
		throw new RuntimeException();
	}

	/**
	 * Compares this object against the specified object. The result is {@code true} if and only if the
	 * argument is not {@code null} and is a {@code Character} object that represents the same
	 * {@code char} value as this object.
	 *
	 * @param obj
	 *        the object to compare with.
	 * @return {@code true} if the objects are the same; {@code false} otherwise.
	 */
	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	/**
	 * Returns a hash code for this {@code Character}; equal to the result of invoking
	 * {@code charValue()}.
	 *
	 * @return a hash code value for this {@code Character}
	 */
	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	/**
	 * Returns a {@code String} object representing this {@code Character}'s value. The result is a
	 * string of length 1 whose sole component is the primitive {@code char} value represented by this
	 * {@code Character} object.
	 *
	 * @return a string representation of this object.
	 */
	@Override
	public String toString() {
		throw new RuntimeException();
	}
}