/*
 * Decompiled with CFR 0.152.
 */
package ej.service.loader;

import ej.service.ServiceLoadingException;

public class ServiceLoaderHelper {
    private ServiceLoaderHelper() {
    }

    public static <T> T createClassInstance(Class<T> parent, String className) throws ServiceLoadingException {
        try {
            Class<?> clazz = Class.forName(className);
            if (!parent.isAssignableFrom(clazz)) {
                throw new ClassCastException();
            }
            Class<?> clazzTyped = clazz;
            return ServiceLoaderHelper.createClassInstance(parent, clazzTyped);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            String parentName = parent.getName();
            throw new ServiceLoadingException(parentName, e);
        }
    }

    public static <T> T createClassInstance(Class<T> parent, Class<? extends T> clazz) throws ServiceLoadingException {
        try {
            T implementation = clazz.newInstance();
            return implementation;
        }
        catch (IllegalAccessException | InstantiationException e) {
            String parentName = parent.getName();
            throw new ServiceLoadingException(parentName, e);
        }
    }
}

