/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.outline.border;

import ej.annotation.Nullable;
import ej.bon.XMath;
import ej.microui.display.GraphicsContext;
import ej.mwt.style.outline.Outline;
import ej.mwt.style.outline.border.BorderHelper;
import ej.mwt.util.Outlineable;
import ej.mwt.util.Size;

public class RectangularBorder
implements Outline {
    private final int color;
    private final char thickness;

    public RectangularBorder(int color, int thickness) {
        this.color = color;
        this.thickness = (char)XMath.limit((int)thickness, (int)0, (int)65535);
    }

    public int getColor() {
        return this.color;
    }

    public int getThickness() {
        return this.thickness;
    }

    @Override
    public void apply(Outlineable outlineable) {
        char thickness = this.thickness;
        outlineable.removeOutline(thickness, thickness, thickness, thickness);
    }

    @Override
    public void apply(GraphicsContext g, Size size) {
        int width = size.getWidth();
        int height = size.getHeight();
        char thickness = this.thickness;
        g.setColor(this.color);
        BorderHelper.drawRectangularBorder(g, width, height, thickness, thickness, thickness, thickness);
        size.removeOutline(thickness, thickness, thickness, thickness);
        g.translate((int)thickness, (int)thickness);
        g.intersectClip(0, 0, size.getWidth(), size.getHeight());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            RectangularBorder border = (RectangularBorder)obj;
            return this.color == border.color && this.thickness == border.thickness;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 11 * this.color + 13 * this.thickness;
    }
}

