/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget.display.buffer;

import ej.fp.FrontPanel;
import ej.fp.Image;
import ej.fp.Widget;
import ej.fp.widget.display.DisplayBufferManager;
import ej.fp.widget.display.buffer.DisplayBufferPolicy;
import ej.microui.display.Rectangle;

public class TransmitSwapBufferPolicy
implements DisplayBufferPolicy {
    private Widget displayWidget;
    private int displayWidth;
    private int displayHeight;
    private Image bufferA;
    private Image bufferB;
    private Image frontBuffer;
    private boolean drawingOnBufferA;
    private int currentFlush;
    private int ackFlush;

    @Override
    public void setDisplayProperties(Widget displayWidget, int width, int height, int initialColor) {
        this.displayWidget = displayWidget;
        this.displayWidth = width;
        this.displayHeight = height;
        this.bufferA = FrontPanel.getFrontPanel().newImage(this.displayWidth, this.displayHeight, initialColor, false);
        this.bufferB = FrontPanel.getFrontPanel().newImage(this.displayWidth, this.displayHeight, initialColor, false);
        this.frontBuffer = FrontPanel.getFrontPanel().newImage(this.displayWidth, this.displayHeight, initialColor, false);
    }

    @Override
    public int getBufferCount() {
        return 2;
    }

    @Override
    public boolean isDoubleBuffered() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(final DisplayBufferManager bufferManager, Rectangle[] rectangles) {
        Object monitor;
        Object object = monitor = bufferManager.getMonitor();
        synchronized (object) {
            while (this.currentFlush != this.ackFlush) {
                try {
                    monitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        Rectangle[] rectangleArray = rectangles;
        int n = rectangles.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle = rectangleArray[n2];
            this.frontBuffer.drawImage(this.getBackBuffer(), rectangle.getX1(), rectangle.getY1(), rectangle.getWidth(), rectangle.getHeight(), rectangle.getX1(), rectangle.getY1(), rectangle.getWidth(), rectangle.getHeight());
            ++n2;
        }
        this.swap();
        ++this.currentFlush;
        this.displayWidget.repaint();
        new Thread(){

            @Override
            public void run() {
                bufferManager.simulateFlushTime();
                TransmitSwapBufferPolicy.this.tryToReuse(bufferManager);
            }
        }.start();
    }

    private void swap() {
        this.drawingOnBufferA = !this.drawingOnBufferA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToReuse(DisplayBufferManager bufferManager) {
        Object monitor;
        Object object = monitor = bufferManager.getMonitor();
        synchronized (object) {
            if (bufferManager.isCleanBuffer()) {
                this.swap();
            }
            ++this.ackFlush;
            monitor.notifyAll();
        }
    }

    @Override
    public Image getBackBuffer() {
        if (this.drawingOnBufferA) {
            return this.bufferA;
        }
        return this.bufferB;
    }

    @Override
    public Image getFrontBuffer() {
        return this.frontBuffer;
    }

    @Override
    public void dispose() {
        FrontPanel.getFrontPanel().disposeIfNotNull(new Image[]{this.bufferA, this.bufferB});
    }
}

