/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget.display.brs;

import ej.fp.Image;
import ej.fp.widget.display.DisplayBufferManager;
import ej.fp.widget.display.brs.BufferRefreshStrategy;
import ej.microui.display.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PredrawRefreshStrategy
implements BufferRefreshStrategy {
    private int displayWidth;
    private int displayHeight;
    private List<Rectangle>[] dirtyRectangles;
    private int currentDirtyRectangle;
    private List<Rectangle> currentDirtyRectangles;
    private Image previousBackBuffer;
    private boolean hasFlushed;

    @Override
    public void setDisplaySize(int width, int height) {
        this.displayWidth = width;
        this.displayHeight = height;
    }

    @Override
    public void setBufferCount(int bufferCount) {
        int count = Math.max(bufferCount - 1, 1);
        this.dirtyRectangles = new List[count];
        int i = 0;
        while (i < count) {
            this.dirtyRectangles[i] = new ArrayList<Rectangle>();
            ++i;
        }
        this.currentDirtyRectangles = new ArrayList<Rectangle>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newDrawingRegion(DisplayBufferManager bufferManager, Rectangle rectangle, boolean drawingNow) {
        if (drawingNow) {
            Image currentBackBuffer = bufferManager.getCurrentBackBuffer();
            Object object = bufferManager.getMonitor();
            synchronized (object) {
                if (this.hasFlushed) {
                    this.hasFlushed = false;
                    if (this.previousBackBuffer != currentBackBuffer) {
                        List<Rectangle> dirtyRectanglesBuffer = this.dirtyRectangles[this.currentDirtyRectangle];
                        if (!this.isFullSize(rectangle)) {
                            this.cleanDirtyRectangles(rectangle, dirtyRectanglesBuffer);
                            for (Rectangle dirtyRectangle : dirtyRectanglesBuffer) {
                                bufferManager.restore(dirtyRectangle);
                            }
                        }
                        dirtyRectanglesBuffer.clear();
                        this.currentDirtyRectangle = (this.currentDirtyRectangle + 1) % this.dirtyRectangles.length;
                    }
                    this.currentDirtyRectangles.clear();
                }
                this.add(this.currentDirtyRectangles, rectangle);
                this.addRectangleToOtherBuffers(rectangle);
            }
            this.previousBackBuffer = currentBackBuffer;
        } else {
            if (!this.hasFlushed) {
                List<Rectangle> dirtyRectanglesBuffer = this.dirtyRectangles[this.currentDirtyRectangle];
                this.cleanDirtyRectangles(rectangle, dirtyRectanglesBuffer);
            }
            this.addRectangleToOtherBuffers(rectangle);
        }
    }

    private void cleanDirtyRectangles(Rectangle drawnRectangle, List<Rectangle> dirtyRectanglesBuffer) {
        ArrayList<Rectangle> parts = new ArrayList<Rectangle>();
        Iterator<Rectangle> iterator = dirtyRectanglesBuffer.iterator();
        while (iterator.hasNext()) {
            Rectangle candidate = iterator.next();
            if (drawnRectangle.contains(candidate)) {
                iterator.remove();
                continue;
            }
            if (!candidate.contains(drawnRectangle)) continue;
            int x1 = drawnRectangle.getX1();
            int x2 = drawnRectangle.getX2();
            int y1 = drawnRectangle.getY1();
            int y2 = drawnRectangle.getY2();
            iterator.remove();
            if (candidate.getY1() != y1) {
                parts.add(new Rectangle(candidate.getX1(), candidate.getY1(), candidate.getX2(), y1 - 1));
            }
            if (candidate.getY2() != y2) {
                parts.add(new Rectangle(candidate.getX1(), y2 + 1, candidate.getX2(), candidate.getY2()));
            }
            if (candidate.getX1() != x1) {
                parts.add(new Rectangle(candidate.getX1(), y1, x1 - 1, y2));
            }
            if (candidate.getX2() == x2) continue;
            parts.add(new Rectangle(x2 + 1, y1, candidate.getX2(), y2));
        }
        dirtyRectanglesBuffer.addAll(parts);
    }

    private void addRectangleToOtherBuffers(Rectangle rectangle) {
        int i = 0;
        while (i < this.dirtyRectangles.length) {
            List<Rectangle> dirtyRectanglesBuffer = this.dirtyRectangles[i];
            this.add(dirtyRectanglesBuffer, rectangle);
            ++i;
        }
    }

    private void add(List<Rectangle> rectangles, Rectangle rectangle) {
        if (!rectangles.isEmpty()) {
            Rectangle lastRectangle = rectangles.get(rectangles.size() - 1);
            if (lastRectangle.contains(rectangle)) {
                return;
            }
            if (rectangle.contains(lastRectangle)) {
                rectangles.remove(rectangles.size() - 1);
            }
        }
        rectangles.add(rectangle);
    }

    @Override
    public void refresh(DisplayBufferManager bufferManager) {
        ArrayList<Rectangle> dirtyRectangles = new ArrayList<Rectangle>(this.currentDirtyRectangles);
        bufferManager.flush(dirtyRectangles.toArray(new Rectangle[dirtyRectangles.size()]));
        this.hasFlushed = true;
    }

    private boolean isFullSize(Rectangle rectangle) {
        return rectangle.getX1() == 0 && rectangle.getY1() == 0 && rectangle.getX2() == this.displayWidth - 1 && rectangle.getY2() == this.displayHeight - 1;
    }
}

