/*
 * Decompiled with CFR 0.152.
 */
package ej.microui.event;

import ej.fp.FrontPanel;
import ej.microui.event.LLUIInput;

public class EventCommand {
    public static final String COMMON_MICROUI_GENERATOR_TAG = "COMMANDS";
    public static final int ESC = 0;
    public static final int BACK = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    public static final int LEFT = 4;
    public static final int RIGHT = 5;
    public static final int SELECT = 6;
    public static final int CANCEL = 7;
    public static final int HELP = 8;
    public static final int MENU = 9;
    public static final int EXIT = 10;
    public static final int START = 11;
    public static final int STOP = 12;
    public static final int PAUSE = 13;
    public static final int RESUME = 14;
    public static final int COPY = 15;
    public static final int CUT = 16;
    public static final int PASTE = 17;
    public static final int CLOCKWISE = 18;
    public static final int ANTICLOCKWISE = 19;
    public static final int PREVIOUS = 20;
    public static final int NEXT = 21;
    public static final int DISPLAY = 22;
    private static final int COMMAND_DRIVER_COMMAND_MASK = 65535;
    private static final int COMMAND_DRIVER_COMMAND_SHIFT = 0;

    private EventCommand() {
    }

    public static void sendEvent(int command) {
        EventCommand.sendEvent(COMMON_MICROUI_GENERATOR_TAG, command);
    }

    public static void sendEvent(String commandsEventGenerator, int command) {
        try {
            LLUIInput.sendEvent(commandsEventGenerator, command << 0 & 0xFFFF);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EventCommand.traceEvent(commandsEventGenerator, command);
        }
    }

    private static void traceEvent(String commandsEventGenerator, int command) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(EventCommand.class.getName());
        buf.append("] ");
        buf.append("command 0x");
        buf.append(Integer.toHexString(command));
        buf.append(" (");
        buf.append(commandsEventGenerator);
        buf.append(")");
        FrontPanel.out.println(buf.toString());
    }
}

