/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.container;

import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.util.Size;

public class List
extends Container {
    private boolean orientation;
    private int totalLength;

    public List(boolean orientation) {
        this.orientation = orientation;
    }

    public void setOrientation(boolean orientation) {
        this.orientation = orientation;
    }

    public boolean getOrientation() {
        return this.orientation;
    }

    public void addChild(Widget child) {
        super.addChild(child);
    }

    public void removeChild(Widget child) {
        super.removeChild(child);
    }

    public void insertChild(Widget child, int index) {
        super.insertChild(child, index);
    }

    public void replaceChild(int index, Widget child) {
        super.replaceChild(index, child);
    }

    public void removeAllChildren() {
        super.removeAllChildren();
    }

    protected void computeContentOptimalSize(Size size) {
        int childrenCount = this.getChildrenCount();
        if (childrenCount == 0) {
            size.setSize(0, 0);
            return;
        }
        boolean isHorizontal = this.orientation;
        int childWidthHint = size.getWidth();
        int childHeightHint = size.getHeight();
        int totalWidth = 0;
        int totalHeight = 0;
        Widget[] widgetArray = this.getChildren();
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            assert (widget != null);
            this.computeChildOptimalSize(widget, childWidthHint, childHeightHint);
            if (isHorizontal) {
                totalWidth += widget.getWidth();
                totalHeight = Math.max(totalHeight, widget.getHeight());
            } else {
                totalWidth = Math.max(totalWidth, widget.getWidth());
                totalHeight += widget.getHeight();
            }
            ++n2;
        }
        this.totalLength = isHorizontal ? totalWidth : totalHeight;
        size.setSize(totalWidth, totalHeight);
    }

    protected void layOutChildren(int contentWidth, int contentHeight) {
        int totalLength = this.totalLength;
        if (totalLength == 0) {
            return;
        }
        boolean isHorizontal = this.orientation;
        int contentLength = isHorizontal ? contentWidth : contentHeight;
        int widgetPosition = 0;
        Widget[] widgetArray = this.getChildren();
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget child = widgetArray[n2];
            assert (child != null);
            int widgetLength = isHorizontal ? child.getWidth() : child.getHeight();
            int widgetStart = widgetPosition * contentLength / totalLength;
            int widgetEnd = (widgetPosition + widgetLength) * contentLength / totalLength;
            if (isHorizontal) {
                this.layOutChild(child, widgetStart, 0, widgetEnd - widgetStart, contentHeight);
            } else {
                this.layOutChild(child, 0, widgetStart, contentWidth, widgetEnd - widgetStart);
            }
            widgetPosition += widgetLength;
            ++n2;
        }
    }
}

