/*
 * Decompiled with CFR 0.152.
 */
package ej.basictool;

import ej.bon.Util;

public final class ArrayTools {
    private ArrayTools() {
    }

    public static void checkBounds(byte[] bytes, int offset, int length) {
        if (!ArrayTools.checkBoundsInternal(bytes.length, offset, length)) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static void checkBounds(int arrayLength, int offset, int length) {
        if (!ArrayTools.checkBoundsInternal(arrayLength, offset, length)) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static void checkArrayBounds(int arrayLength, int offset, int length) {
        if (!ArrayTools.checkBoundsInternal(arrayLength, offset, length)) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static void checkStringBounds(int stringLength, int offset, int length) {
        if (!ArrayTools.checkBoundsInternal(stringLength, offset, length)) {
            throw new StringIndexOutOfBoundsException();
        }
    }

    private static boolean checkBoundsInternal(int arrayLength, int offset, int length) {
        int offsetPlusLength = offset + length;
        return offset >= 0 && length >= 0 && offsetPlusLength <= arrayLength && offsetPlusLength >= 0;
    }

    public static int[] grow(int[] array, int index, int count) {
        ArrayTools.checkCount(count);
        int arrayLength = array.length;
        int[] result = new int[arrayLength + count];
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index, result, index + count, arrayLength - index);
        return result;
    }

    public static <T> T[] grow(T[] array, int index, int count) {
        ArrayTools.checkCount(count);
        int arrayLength = array.length;
        T[] result = ArrayTools.createNewArray(array, arrayLength + count);
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index, result, index + count, arrayLength - index);
        return result;
    }

    public static int[] shrink(int[] array, int index, int count) {
        ArrayTools.checkCount(count);
        int arrayLength = array.length;
        int[] result = new int[arrayLength - count];
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + count, result, index, arrayLength - index - count);
        return result;
    }

    public static <T> T[] shrink(T[] array, int index, int count) {
        ArrayTools.checkCount(count);
        int arrayLength = array.length;
        T[] result = ArrayTools.createNewArray(array, arrayLength - count);
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + count, result, index, arrayLength - index - count);
        return result;
    }

    private static void checkCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
    }

    public static <T> T[] add(T[] array, T element) {
        int arrayLength = array.length;
        T[] result = ArrayTools.grow(array, arrayLength, 1);
        result[arrayLength] = element;
        return result;
    }

    public static <T> T[] add(T[] array, T[] other) {
        int arrayLength = array.length;
        int otherLength = other.length;
        T[] result = ArrayTools.grow(array, arrayLength, otherLength);
        System.arraycopy(other, 0, result, arrayLength, otherLength);
        return result;
    }

    public static byte[] concat(byte[] array1, byte[] array2) {
        return ArrayTools.concatRanges(array1, 0, array1.length, array2, 0, array2.length);
    }

    public static byte[] concatRanges(byte[] array1, int offset1, int length1, byte[] array2, int offset2, int length2) {
        byte[] result = new byte[length1 + length2];
        System.arraycopy(array1, offset1, result, 0, length1);
        System.arraycopy(array2, offset2, result, length1, length2);
        return result;
    }

    public static <T> T[] insert(T[] array, int index, T element) {
        T[] result = ArrayTools.grow(array, index, 1);
        result[index] = element;
        return result;
    }

    public static <T> T[] remove(T[] array, T element) {
        int index = ArrayTools.getIndex(array, element);
        if (index != -1) {
            array = ArrayTools.shrink(array, index, 1);
        }
        return array;
    }

    public static <T> T[] removeEquals(T[] array, T element) {
        int index = ArrayTools.getIndexEquals(array, element);
        if (index != -1) {
            array = ArrayTools.shrink(array, index, 1);
        }
        return array;
    }

    public static <T> T[] remove(T[] array, int index) {
        return ArrayTools.shrink(array, index, 1);
    }

    public static <T> boolean contains(T[] array, T element) {
        return ArrayTools.getIndex(array, element) != -1;
    }

    public static <T> boolean containsEquals(T[] array, T element) {
        return ArrayTools.getIndexEquals(array, element) != -1;
    }

    public static int getIndex(int[] array, int element) {
        int arrayLength;
        int i = arrayLength = array.length;
        while (--i >= 0) {
            if (element != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static <T> int getIndex(T[] array, T element) {
        int arrayLength;
        int i = arrayLength = array.length;
        while (--i >= 0) {
            if (element != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static <T> int getIndexEquals(T[] array, T element) {
        int arrayLength = array.length;
        int i = 0;
        while (i < arrayLength) {
            if (element.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Deprecated
    public static <T> T[] copy(T[] array) {
        return (Object[])array.clone();
    }

    @Deprecated
    public static <T> T[] copy(Object[] array, Class<T[]> type) {
        return ArrayTools.copyInternal(array, array.length, type);
    }

    public static int[] add(int[] array, int element) {
        int arrayLength = array.length;
        int[] result = ArrayTools.grow(array, arrayLength, 1);
        result[arrayLength] = element;
        return result;
    }

    public static int[] remove(int[] array, int element) {
        int index = ArrayTools.getIndex(array, element);
        if (index != -1) {
            array = ArrayTools.shrink(array, index, 1);
        }
        return array;
    }

    @Deprecated
    public static int[] removeRange(int[] array, int offset, int length) {
        return ArrayTools.shrink(array, offset, length);
    }

    public static boolean contains(int[] array, int element) {
        return ArrayTools.getIndex(array, element) != -1;
    }

    @Deprecated
    public static int[] copy(int[] array) {
        return (int[])array.clone();
    }

    public static boolean equalsRanges(byte[] array1, int offset1, byte[] array2, int offset2, int length) {
        int i = 0;
        while (i < length) {
            if (array1[offset1 + i] != array2[offset2 + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T> T[] add(T[] array, T element, int pointer) {
        try {
            array[pointer] = element;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            T[] result = ArrayTools.createNewArray(array, (pointer << 1) + 1);
            System.arraycopy(array, 0, result, 0, array.length);
            array = result;
            array[pointer] = element;
        }
        return array;
    }

    public static <T> T[] insert(T[] array, int index, T element, int pointer) {
        T[] result;
        int arrayLength = array.length;
        if (pointer == arrayLength) {
            result = ArrayTools.createNewArray(array, (pointer << 1) + 1);
            System.arraycopy(array, 0, result, 0, index);
        } else {
            result = array;
        }
        System.arraycopy(array, index, result, index + 1, pointer - index);
        result[index] = element;
        return result;
    }

    public static <T> boolean remove(T[] array, T element, int pointer) {
        int i = pointer;
        while (--i >= 0) {
            if (array[i] != element) continue;
            System.arraycopy(array, 0, array, 0, i);
            System.arraycopy(array, i + 1, array, i, pointer - i);
            array[pointer] = null;
            return true;
        }
        return false;
    }

    public static <T> boolean removeEquals(T[] array, T element, int pointer) {
        int i = pointer;
        while (--i >= 0) {
            if (!element.equals(array[i])) continue;
            System.arraycopy(array, 0, array, 0, i);
            System.arraycopy(array, i + 1, array, i, pointer - i);
            array[pointer] = null;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T[] array, T element, int pointer) {
        int i = pointer;
        while (--i >= 0) {
            if (element != array[i]) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsEquals(T[] array, T element, int pointer) {
        int i = pointer;
        while (--i >= 0) {
            if (!element.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    public static <T> int getIndex(T[] array, T element, int pointer) {
        int i = pointer;
        while (--i >= 0) {
            if (element != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static <T> int getIndexEquals(T[] array, T element, int pointer) {
        int i = pointer;
        while (--i >= 0) {
            if (!element.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public static <T> T[] copy(T[] array, int pointer) {
        return ArrayTools.copyInternal(array, pointer + 1);
    }

    @Deprecated
    public static <T> T[] copy(Object[] array, int pointer, Class<T[]> type) {
        return ArrayTools.copyInternal(array, pointer + 1, type);
    }

    public static int[] add(int[] array, int element, int pointer) {
        try {
            array[pointer] = element;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int[] result = new int[(pointer << 1) + 1];
            System.arraycopy(array, 0, result, 0, array.length);
            array = result;
            array[pointer] = element;
        }
        return array;
    }

    public static boolean remove(int[] array, int element, int pointer) {
        int arrayLength;
        int i = arrayLength = array.length;
        while (--i >= 0) {
            if (array[i] != element) continue;
            System.arraycopy(array, 0, array, 0, i);
            System.arraycopy(array, i + 1, array, i, pointer - i);
            array[pointer] = 0;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] array, int element, int pointer) {
        int i = pointer;
        while (--i >= 0) {
            if (element != array[i]) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static int[] copy(int[] array, int pointer) {
        int arrayLength = pointer + 1;
        int[] result = new int[arrayLength];
        System.arraycopy(array, 0, result, 0, arrayLength);
        return result;
    }

    private static <T> T[] copyInternal(Object[] array, int arrayLength, Class<T[]> type) {
        Object[] result = Util.newArray(type, (int)arrayLength);
        System.arraycopy(array, 0, result, 0, arrayLength);
        return result;
    }

    private static <T> T[] copyInternal(T[] array, int arrayLength) {
        T[] result = ArrayTools.createNewArray(array, arrayLength);
        System.arraycopy(array, 0, result, 0, arrayLength);
        return result;
    }

    public static <T> T[] createNewArray(T[] array, int length) {
        return Util.newArray(array.getClass(), (int)length);
    }

    @Deprecated
    public static <T> T[] createNewArray(Class<T[]> type, int length) {
        return Util.newArray(type, (int)length);
    }
}

