/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util;

import com.microej.kf.util.ReadResult;
import com.microej.kf.util.message.KfUtilMessage;
import ej.kf.Feature;
import ej.kf.Kernel;
import ej.kf.Module;
import ej.kf.Proxy;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamProxy
extends InputStream {
    private final Proxy<InputStream> inputStreamRef;

    public InputStreamProxy(Proxy<InputStream> inputStreamRef) {
        this.inputStreamRef = inputStreamRef;
    }

    @Override
    public int available() throws IOException {
        Kernel.enter();
        try {
            return ((InputStream)this.inputStreamRef.getReference()).available();
        }
        catch (Throwable t) {
            KfUtilMessage.LOGGER.log('I', "KfUtil", 0, t);
            throw new IOException();
        }
    }

    @Override
    public void close() throws IOException {
        Kernel.enter();
        try {
            ((InputStream)this.inputStreamRef.getReference()).close();
            return;
        }
        catch (Throwable t) {
            KfUtilMessage.LOGGER.log('I', "KfUtil", 0, t);
            throw new IOException();
        }
    }

    @Override
    public int read() throws IOException {
        Kernel.enter();
        try {
            return ((InputStream)this.inputStreamRef.getReference()).read();
        }
        catch (Throwable t) {
            KfUtilMessage.LOGGER.log('I', "KfUtil", 0, t);
            throw new IOException();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        Kernel.enter();
        try {
            return ((InputStream)this.inputStreamRef.getReference()).skip(n);
        }
        catch (Throwable t) {
            KfUtilMessage.LOGGER.log('I', "KfUtil", 0, t);
            throw new IOException();
        }
    }

    @Override
    public int read(byte[] b, int off, final int len) throws IOException {
        Kernel.enter();
        final InputStream target = (InputStream)this.inputStreamRef.getReference();
        if (target == null) {
            throw new IOException();
        }
        Feature owner = (Feature)Kernel.getOwner((Object)target);
        ReadResult r = new ReadResult(){

            @Override
            public byte[] runWithResult() {
                byte[] bytes = new byte[len];
                try {
                    this.nbRead = target.read(bytes, 0, len);
                }
                catch (IOException iOException) {
                    return null;
                }
                return bytes;
            }
        };
        Kernel.runUnderContext((Module)owner, (Runnable)r);
        int bytesRead = r.nbRead;
        if (bytesRead == -1) {
            return -1;
        }
        byte[] bytes = (byte[])r.getResult();
        if (bytes != null) {
            System.arraycopy(bytes, 0, b, off, bytesRead);
            return bytesRead;
        }
        Kernel.exit();
        throw new IOException();
    }
}

