/*
 * Decompiled with CFR 0.152.
 */
package com.microej.tool.classextender.helper;

import com.microej.tool.classextender.helper.ExtendClassFilter;
import ej.basictool.annotation.Extend;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtensionClassLoader
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(ExtensionClassLoader.class.getName());
    private final File[] classpath;
    private final URLClassLoader urlClassLoader;

    public ExtensionClassLoader(File ... classpath) {
        URL[] urls = new URL[classpath.length];
        int i = 0;
        while (i < classpath.length) {
            try {
                urls[i] = classpath[i].toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.SEVERE, "An error occured while instantiating class loader: {0}", e.getMessage());
            }
            ++i;
        }
        this.classpath = classpath;
        this.urlClassLoader = new URLClassLoader(urls, Extend.class.getClassLoader());
    }

    public File[] getClasspath() {
        return this.classpath;
    }

    public Class<?> loadClass(String fullyQualifiedName) throws ClassNotFoundException {
        LOGGER.log(Level.FINEST, "try to load class: {0}", fullyQualifiedName);
        Class<?> loadedClass = this.urlClassLoader.loadClass(fullyQualifiedName);
        LOGGER.log(Level.FINEST, "Class {0} as been succesfully loaded", loadedClass.getName());
        return loadedClass;
    }

    private Class<?> loadClassOrNull(String fullyQualifiedName) {
        try {
            return this.loadClass(fullyQualifiedName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.severe(e.getMessage());
            return null;
        }
    }

    public List<Class<?>> findClasses(ExtendClassFilter filter) {
        ArrayList classes = new ArrayList();
        URL[] uRLArray = this.urlClassLoader.getURLs();
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            File file = new File(url.getFile());
            ArrayList<File> classFiles = new ArrayList<File>();
            if (file.isDirectory()) {
                LOGGER.log(Level.FINEST, "Looking for extensions in directory: {0}", file);
                this.walkDirectory(file, filter, classFiles);
                int rootIndex = file.getAbsolutePath().length();
                for (File classFile : classFiles) {
                    String relativePath = classFile.getAbsolutePath().substring(rootIndex + 1);
                    String fqn = relativePath.replace(File.separatorChar, '.').substring(0, relativePath.length() - 6);
                    Class<?> acceptedClass = this.loadClassOrNull(fqn);
                    if (acceptedClass == null) continue;
                    LOGGER.log(Level.FINEST, "Found extension class: {0}", acceptedClass.getCanonicalName());
                    classes.add(acceptedClass);
                }
                return classes;
            }
            new ArrayList();
            try {
                Throwable rootIndex = null;
                Object var10_13 = null;
                try (JarFile jar = new JarFile(file);){
                    LOGGER.log(Level.FINEST, "Looking for extensions in jar: {0}", jar.getName());
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        if (filter.accept(jar, jarEntry)) {
                            LOGGER.log(Level.FINEST, "{0} is an extension", jarEntry.getName());
                            String classFilePath = jarEntry.getName();
                            String fqn = classFilePath.replace('/', '.').substring(0, classFilePath.length() - 6);
                            Class<?> acceptedClass = this.loadClassOrNull(fqn);
                            if (acceptedClass == null) continue;
                            LOGGER.log(Level.FINEST, "Found extension class: {0}", acceptedClass.getCanonicalName());
                            classes.add(acceptedClass);
                            continue;
                        }
                        LOGGER.log(Level.FINEST, "{0} is not an extension", jarEntry.getName());
                    }
                }
                catch (Throwable throwable) {
                    if (rootIndex == null) {
                        rootIndex = throwable;
                    } else if (rootIndex != throwable) {
                        rootIndex.addSuppressed(throwable);
                    }
                    throw rootIndex;
                }
            }
            catch (IOException e) {
                LOGGER.warning(e.getMessage());
            }
            ++n2;
        }
        return classes;
    }

    private void walkDirectory(File file, FileFilter filter, Collection<File> filteredFiles) {
        if (file.isFile() && filter.accept(file)) {
            filteredFiles.add(file);
        } else if (file.isDirectory()) {
            Arrays.stream(file.listFiles()).forEach(f -> this.walkDirectory((File)f, filter, filteredFiles));
        }
    }

    @Override
    public void close() {
        try {
            this.urlClassLoader.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "An exception occured while closing class loader:", e);
        }
    }
}

