/*
 * Decompiled with CFR 0.152.
 */
package ej.net.util.wifi;

import ej.annotation.NonNull;
import ej.ecom.wifi.SecurityMode;

public class SecurityUtil {
    private static final String WPA2 = "WPA2";
    private static final String WPA1 = "WPA1";
    private static final String WEP64 = "Wep64";
    private static final String WEP128 = "Wep128";
    private static final String OPEN = "Open";
    private static final String MIXED = "Mixed";
    private static final String ENTREPRISE_WPA_MIXED = "Enterprise WPA Mixed";
    private static final String ENTREPRISE_WPA2 = "Enterprise WPA2";
    private static final String ENTREPRISE_WPA1 = "Enterprise WPA1";
    private static final String ENTREPRISE_NO_SECURITY = "Enterprise No Security";
    private static final String ENTREPRISE_WEP = "Enterprise WEP";

    private SecurityUtil() {
    }

    public static String getSecurityModeText(@NonNull SecurityMode securityMode) {
        String value = null;
        switch (securityMode) {
            case EnterpriseWEP: {
                value = ENTREPRISE_WEP;
                break;
            }
            case Enterprise_NO_security: {
                value = ENTREPRISE_NO_SECURITY;
                break;
            }
            case Enterprise_WPA1: {
                value = ENTREPRISE_WPA1;
                break;
            }
            case Enterprise_WPA2: {
                value = ENTREPRISE_WPA2;
                break;
            }
            case Enterprise_WPA_mixed: {
                value = ENTREPRISE_WPA_MIXED;
                break;
            }
            case MIXED: {
                value = MIXED;
                break;
            }
            case OPEN: {
                value = OPEN;
                break;
            }
            case WEP128: {
                value = WEP128;
                break;
            }
            case WEP64: {
                value = WEP64;
                break;
            }
            case WPA1: {
                value = WPA1;
                break;
            }
            case WPA2: {
                value = WPA2;
                break;
            }
        }
        return value;
    }

    public static SecurityMode getSecurityMode(@NonNull String securityMode) {
        SecurityMode value = null;
        if (securityMode.equalsIgnoreCase(ENTREPRISE_WEP)) {
            value = SecurityMode.EnterpriseWEP;
        } else if (securityMode.equalsIgnoreCase(ENTREPRISE_NO_SECURITY)) {
            value = SecurityMode.Enterprise_NO_security;
        } else if (securityMode.equalsIgnoreCase(ENTREPRISE_WPA1)) {
            value = SecurityMode.Enterprise_WPA1;
        } else if (securityMode.equalsIgnoreCase(ENTREPRISE_WPA2)) {
            value = SecurityMode.Enterprise_WPA2;
        } else if (securityMode.equalsIgnoreCase(ENTREPRISE_WPA_MIXED)) {
            value = SecurityMode.Enterprise_WPA_mixed;
        } else if (securityMode.equalsIgnoreCase(MIXED)) {
            value = SecurityMode.MIXED;
        } else if (securityMode.equalsIgnoreCase(OPEN)) {
            value = SecurityMode.OPEN;
        } else if (securityMode.equalsIgnoreCase(WEP128)) {
            value = SecurityMode.WEP128;
        } else if (securityMode.equalsIgnoreCase(WEP64)) {
            value = SecurityMode.WEP64;
        } else if (securityMode.equalsIgnoreCase(WPA1)) {
            value = SecurityMode.WPA1;
        } else if (securityMode.equalsIgnoreCase(WPA2)) {
            value = SecurityMode.WPA2;
        }
        return value;
    }
}

