/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.DuplicateFormatFlagsException;
import java.util.FormatFlagsConversionMismatchException;
import java.util.FormatterClosedException;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.List;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.Objects;
import java.util.UnknownFormatConversionException;
import java.util.UnknownFormatFlagsException;
import sun.misc.FormattedFloatingDecimal;

public final class Formatter
implements Closeable,
Flushable {
    private Appendable a;
    private IOException lastException;

    private static final Appendable nonNullAppendable(Appendable a) {
        if (a == null) {
            return new StringBuilder();
        }
        return a;
    }

    public Formatter() {
        this(new StringBuilder());
    }

    public Formatter(Appendable a) {
        this.a = Formatter.nonNullAppendable(a);
    }

    public Formatter(PrintStream ps) {
        this((Appendable)Objects.requireNonNull(ps));
    }

    public Formatter(OutputStream os) {
        this(new BufferedWriter(new OutputStreamWriter(Objects.requireNonNull(os))));
    }

    public Formatter(OutputStream os, String csn) throws UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter(Objects.requireNonNull(os), csn)));
    }

    public Appendable out() {
        this.ensureOpen();
        return this.a;
    }

    public String toString() {
        this.ensureOpen();
        return this.a.toString();
    }

    @Override
    public void flush() {
        this.ensureOpen();
        if (this.a instanceof Flushable) {
            try {
                ((Flushable)((Object)this.a)).flush();
            }
            catch (IOException ioe) {
                this.lastException = ioe;
            }
        }
    }

    @Override
    public void close() {
        if (this.a == null) {
            return;
        }
        try {
            try {
                if (this.a instanceof Closeable) {
                    ((Closeable)((Object)this.a)).close();
                }
            }
            catch (IOException ioe) {
                this.lastException = ioe;
                this.a = null;
            }
        }
        finally {
            this.a = null;
        }
    }

    private void ensureOpen() {
        if (this.a == null) {
            throw new FormatterClosedException();
        }
    }

    public IOException ioException() {
        return this.lastException;
    }

    public Formatter format(String format, Object ... args) {
        this.ensureOpen();
        int last = -1;
        int lasto = -1;
        FormatString[] fsa = this.parse(format);
        int i = 0;
        while (i < fsa.length) {
            FormatString fs = fsa[i];
            int index = fs.index();
            try {
                switch (index) {
                    case -2: {
                        fs.print(null);
                        break;
                    }
                    case -1: {
                        if (last < 0 || args != null && last > args.length - 1) {
                            throw new MissingFormatArgumentException(fs.toString());
                        }
                        fs.print(args == null ? null : args[last]);
                        break;
                    }
                    case 0: {
                        last = ++lasto;
                        if (args != null && lasto > args.length - 1) {
                            throw new MissingFormatArgumentException(fs.toString());
                        }
                        fs.print(args == null ? null : args[lasto]);
                        break;
                    }
                    default: {
                        last = index - 1;
                        if (args != null && last > args.length - 1) {
                            throw new MissingFormatArgumentException(fs.toString());
                        }
                        fs.print(args == null ? null : args[last]);
                        break;
                    }
                }
            }
            catch (IOException x) {
                this.lastException = x;
            }
            ++i;
        }
        return this;
    }

    private FormatString[] parse(String s) {
        ArrayList<FormatString> parts = new ArrayList<FormatString>();
        int lastPosition = 0;
        while (true) {
            int formatIndex;
            if ((formatIndex = s.indexOf(37, lastPosition)) == -1) {
                if (lastPosition >= s.length()) break;
                FixedString fixedString = new FixedString(s.substring(lastPosition, s.length()));
                parts.add(fixedString);
                break;
            }
            if (lastPosition != formatIndex) {
                FixedString fixedString = new FixedString(s.substring(lastPosition, formatIndex));
                parts.add(fixedString);
            }
            int formatEndIndex = this.parseFormat(s, formatIndex, parts);
            lastPosition = formatEndIndex + 1;
        }
        return parts.toArray(new FormatString[parts.size()]);
    }

    private int parseFormat(String s, int formatIndex, List<FormatString> parts) {
        char c;
        int argumentIndex = 0;
        Flags flags = new Flags(0);
        int width = -1;
        int precision = -1;
        int state = 0;
        int number = -1;
        while (true) {
            String numberString;
            int lastNumberIndex;
            if (++formatIndex >= s.length()) {
                throw new UnknownFormatConversionException(s);
            }
            c = s.charAt(formatIndex);
            if (c > '0' && c < '9') {
                lastNumberIndex = this.searchLastNumberIndex(s, formatIndex);
                numberString = s.substring(formatIndex, lastNumberIndex);
                number = new Integer(numberString);
                formatIndex = lastNumberIndex - 1;
                continue;
            }
            if (state == 0 && c == '$') {
                if (number <= 0) {
                    throw new UnknownFormatConversionException(s);
                }
                argumentIndex = number;
                number = -1;
                state = 1;
                continue;
            }
            if (state <= 1 && this.isFlag(c)) {
                Flags newFlags = Flags.parse(c);
                if (flags.contains(newFlags)) {
                    throw new DuplicateFormatFlagsException(newFlags.toString());
                }
                flags.add(newFlags);
                continue;
            }
            if (state <= 2 && number != -1) {
                width = number;
                number = -1;
                state = 3;
                --formatIndex;
                continue;
            }
            if (state <= 3 && c == '.') {
                try {
                    lastNumberIndex = this.searchLastNumberIndex(s, formatIndex);
                    numberString = s.substring(formatIndex + 1, lastNumberIndex);
                    precision = new Integer(numberString);
                    formatIndex = lastNumberIndex - 1;
                    state = 4;
                }
                catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                    throw new UnknownFormatConversionException(s);
                }
            }
            if (state <= 4) break;
        }
        if (!Conversion.isValid(c)) {
            throw new UnknownFormatConversionException(String.valueOf(c));
        }
        if (Character.isUpperCase(c)) {
            flags.add(Flags.UPPERCASE);
        }
        char conversion = Character.toLowerCase(c);
        FormatSpecifier formatSpecifier = new FormatSpecifier(argumentIndex, flags, width, precision, conversion);
        parts.add(formatSpecifier);
        return formatIndex;
    }

    private boolean isFlag(char c) {
        return c == '-' || c == '#' || c == '+' || c == ' ' || c == '0' || c == '(' || c == '<';
    }

    private int searchLastNumberIndex(String s, int numberIndex) {
        char c;
        while ((c = s.charAt(++numberIndex)) >= '0' && c <= '9') {
        }
        return numberIndex;
    }

    private static class Conversion {
        static final char DECIMAL_INTEGER = 'd';
        static final char OCTAL_INTEGER = 'o';
        static final char HEXADECIMAL_INTEGER = 'x';
        static final char HEXADECIMAL_INTEGER_UPPER = 'X';
        static final char DECIMAL_FLOAT = 'f';
        static final char CHARACTER = 'c';
        static final char CHARACTER_UPPER = 'C';
        static final char BOOLEAN = 'b';
        static final char BOOLEAN_UPPER = 'B';
        static final char STRING = 's';
        static final char STRING_UPPER = 'S';
        static final char HASHCODE = 'h';
        static final char HASHCODE_UPPER = 'H';
        static final char LINE_SEPARATOR = 'n';
        static final char PERCENT_SIGN = '%';

        private Conversion() {
        }

        static boolean isValid(char c) {
            return Conversion.isGeneral(c) || Conversion.isInteger(c) || Conversion.isFloat(c) || Conversion.isText(c) || c == 't' || Conversion.isCharacter(c);
        }

        static boolean isGeneral(char c) {
            switch (c) {
                case 'B': 
                case 'H': 
                case 'S': 
                case 'b': 
                case 'h': 
                case 's': {
                    return true;
                }
            }
            return false;
        }

        static boolean isCharacter(char c) {
            switch (c) {
                case 'C': 
                case 'c': {
                    return true;
                }
            }
            return false;
        }

        static boolean isInteger(char c) {
            switch (c) {
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    return true;
                }
            }
            return false;
        }

        static boolean isFloat(char c) {
            switch (c) {
                case 'f': {
                    return true;
                }
            }
            return false;
        }

        static boolean isText(char c) {
            switch (c) {
                case '%': 
                case 'n': {
                    return true;
                }
            }
            return false;
        }
    }

    private class FixedString
    implements FormatString {
        private final String s;

        FixedString(String s) {
            this.s = s;
        }

        @Override
        public int index() {
            return -2;
        }

        @Override
        public void print(Object arg) throws IOException {
            Formatter.this.a.append(this.s);
        }

        @Override
        public String toString() {
            return this.s;
        }
    }

    private static class Flags {
        private int flags;
        static final Flags NONE = new Flags(0);
        static final Flags LEFT_JUSTIFY = new Flags(1);
        static final Flags UPPERCASE = new Flags(2);
        static final Flags ALTERNATE = new Flags(4);
        static final Flags PLUS = new Flags(8);
        static final Flags LEADING_SPACE = new Flags(16);
        static final Flags ZERO_PAD = new Flags(32);
        static final Flags PARENTHESES = new Flags(128);
        static final Flags PREVIOUS = new Flags(256);

        private Flags(int f) {
            this.flags = f;
        }

        public int valueOf() {
            return this.flags;
        }

        public boolean contains(Flags f) {
            return (this.flags & f.valueOf()) == f.valueOf();
        }

        public Flags dup() {
            return new Flags(this.flags);
        }

        private Flags add(Flags f) {
            this.flags |= f.valueOf();
            return this;
        }

        public Flags remove(Flags f) {
            this.flags &= ~f.valueOf();
            return this;
        }

        private static Flags parse(char c) {
            switch (c) {
                case '-': {
                    return LEFT_JUSTIFY;
                }
                case '#': {
                    return ALTERNATE;
                }
                case '+': {
                    return PLUS;
                }
                case ' ': {
                    return LEADING_SPACE;
                }
                case '0': {
                    return ZERO_PAD;
                }
                case '(': {
                    return PARENTHESES;
                }
                case '<': {
                    return PREVIOUS;
                }
            }
            throw new UnknownFormatFlagsException(String.valueOf(c));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.contains(LEFT_JUSTIFY)) {
                sb.append('-');
            }
            if (this.contains(UPPERCASE)) {
                sb.append('^');
            }
            if (this.contains(ALTERNATE)) {
                sb.append('#');
            }
            if (this.contains(PLUS)) {
                sb.append('+');
            }
            if (this.contains(LEADING_SPACE)) {
                sb.append(' ');
            }
            if (this.contains(ZERO_PAD)) {
                sb.append('0');
            }
            if (this.contains(PARENTHESES)) {
                sb.append('(');
            }
            if (this.contains(PREVIOUS)) {
                sb.append('<');
            }
            return sb.toString();
        }
    }

    private class FormatSpecifier
    implements FormatString {
        private int index = -1;
        private Flags f = Flags.NONE;
        private final int width;
        private final int precision;
        private final char c;

        @Override
        public int index() {
            return this.index;
        }

        FormatSpecifier(int argumentIndex, Flags flags, int width, int precision, char conversion) {
            this.index = argumentIndex;
            this.f = flags;
            if (this.f.contains(Flags.PREVIOUS)) {
                this.index = -1;
            }
            this.width = width;
            this.precision = precision;
            this.c = conversion;
            if (Conversion.isText(conversion)) {
                this.index = -2;
            }
            if (Conversion.isGeneral(this.c)) {
                this.checkGeneral();
            } else if (Conversion.isCharacter(this.c)) {
                this.checkCharacter();
            } else if (Conversion.isInteger(this.c)) {
                this.checkInteger();
            } else if (Conversion.isFloat(this.c)) {
                this.checkFloat();
            } else if (Conversion.isText(this.c)) {
                this.checkText();
            } else {
                throw new UnknownFormatConversionException(String.valueOf(this.c));
            }
        }

        @Override
        public void print(Object arg) throws IOException {
            switch (this.c) {
                case 'd': 
                case 'o': 
                case 'x': {
                    this.printInteger(arg);
                    break;
                }
                case 'f': {
                    this.printFloat(arg);
                    break;
                }
                case 'C': 
                case 'c': {
                    this.printCharacter(arg);
                    break;
                }
                case 'b': {
                    this.printBoolean(arg);
                    break;
                }
                case 's': {
                    this.printString(arg);
                    break;
                }
                case 'h': {
                    this.printHashCode(arg);
                    break;
                }
                case 'n': {
                    Formatter.this.a.append(System.getProperty("line.separator"));
                    break;
                }
                case '%': {
                    Formatter.this.a.append('%');
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void printInteger(Object arg) throws IOException {
            if (arg == null) {
                this.print("null");
            } else if (arg instanceof Byte) {
                this.print((Byte)arg);
            } else if (arg instanceof Short) {
                this.print((Short)arg);
            } else if (arg instanceof Integer) {
                this.print((Integer)arg);
            } else if (arg instanceof Long) {
                this.print((Long)arg);
            } else {
                this.failConversion(this.c, arg);
            }
        }

        private void printFloat(Object arg) throws IOException {
            if (arg == null) {
                this.print("null");
            } else if (arg instanceof Float) {
                this.print(((Float)arg).floatValue(), arg);
            } else if (arg instanceof Double) {
                this.print((Double)arg, arg);
            } else {
                this.failConversion(this.c, arg);
            }
        }

        private void printCharacter(Object arg) throws IOException {
            if (arg == null) {
                this.print("null");
                return;
            }
            String s = null;
            if (arg instanceof Character) {
                s = ((Character)arg).toString();
            } else {
                this.failConversion(this.c, arg);
            }
            this.print(s);
        }

        private void printString(Object arg) throws IOException {
            if (this.f.contains(Flags.ALTERNATE)) {
                this.failMismatch(Flags.ALTERNATE, 's');
            }
            if (arg == null) {
                this.print("null");
            } else {
                this.print(arg.toString());
            }
        }

        private void printBoolean(Object arg) throws IOException {
            String s = arg != null ? (arg instanceof Boolean ? ((Boolean)arg).toString() : Boolean.toString(true)) : Boolean.toString(false);
            this.print(s);
        }

        private void printHashCode(Object arg) throws IOException {
            String s = arg == null ? "null" : Integer.toHexString(arg.hashCode());
            this.print(s);
        }

        private void print(String s) throws IOException {
            if (this.precision != -1 && this.precision < s.length()) {
                s = s.substring(0, this.precision);
            }
            if (this.f.contains(Flags.UPPERCASE)) {
                s = s.toUpperCase();
            }
            Formatter.this.a.append(this.justify(s));
        }

        private String justify(String s) {
            int i;
            if (this.width == -1) {
                return s;
            }
            StringBuilder sb = new StringBuilder();
            boolean pad = this.f.contains(Flags.LEFT_JUSTIFY);
            int sp = this.width - s.length();
            if (!pad) {
                i = 0;
                while (i < sp) {
                    sb.append(' ');
                    ++i;
                }
            }
            sb.append(s);
            if (pad) {
                i = 0;
                while (i < sp) {
                    sb.append(' ');
                    ++i;
                }
            }
            return sb.toString();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("%");
            Flags dupf = this.f.dup().remove(Flags.UPPERCASE);
            sb.append(dupf.toString());
            if (this.index > 0) {
                sb.append(this.index).append('$');
            }
            if (this.width != -1) {
                sb.append(this.width);
            }
            if (this.precision != -1) {
                sb.append('.').append(this.precision);
            }
            sb.append(this.f.contains(Flags.UPPERCASE) ? Character.toUpperCase(this.c) : this.c);
            return sb.toString();
        }

        private void checkGeneral() {
            if ((this.c == 'b' || this.c == 'h') && this.f.contains(Flags.ALTERNATE)) {
                this.failMismatch(Flags.ALTERNATE, this.c);
            }
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
            this.checkBadFlags(Flags.PLUS, Flags.LEADING_SPACE, Flags.ZERO_PAD, Flags.PARENTHESES);
        }

        private void checkCharacter() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            this.checkBadFlags(Flags.ALTERNATE, Flags.PLUS, Flags.LEADING_SPACE, Flags.ZERO_PAD, Flags.PARENTHESES);
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
        }

        private void checkInteger() {
            this.checkNumeric();
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            if (this.c == 'd') {
                this.checkBadFlags(Flags.ALTERNATE);
            }
        }

        private void checkBadFlags(Flags ... badFlags) {
            int i = 0;
            while (i < badFlags.length) {
                if (this.f.contains(badFlags[i])) {
                    this.failMismatch(badFlags[i], this.c);
                }
                ++i;
            }
        }

        private void checkFloat() {
            this.checkNumeric();
        }

        private void checkNumeric() {
            if (this.width != -1 && this.width < 0) {
                throw new IllegalFormatWidthException(this.width);
            }
            if (this.precision != -1 && this.precision < 0) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            if (this.width == -1 && (this.f.contains(Flags.LEFT_JUSTIFY) || this.f.contains(Flags.ZERO_PAD))) {
                throw new MissingFormatWidthException(this.toString());
            }
            if (this.f.contains(Flags.PLUS) && this.f.contains(Flags.LEADING_SPACE) || this.f.contains(Flags.LEFT_JUSTIFY) && this.f.contains(Flags.ZERO_PAD)) {
                throw new IllegalFormatFlagsException(this.f.toString());
            }
        }

        private void checkText() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            switch (this.c) {
                case '%': {
                    if (this.f.valueOf() != Flags.LEFT_JUSTIFY.valueOf() && this.f.valueOf() != Flags.NONE.valueOf()) {
                        throw new IllegalFormatFlagsException(this.f.toString());
                    }
                    if (this.width != -1 || !this.f.contains(Flags.LEFT_JUSTIFY)) break;
                    throw new MissingFormatWidthException(this.toString());
                }
                case 'n': {
                    if (this.width != -1) {
                        throw new IllegalFormatWidthException(this.width);
                    }
                    if (this.f.valueOf() == Flags.NONE.valueOf()) break;
                    throw new IllegalFormatFlagsException(this.f.toString());
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void print(byte value) throws IOException {
            long v = value;
            if (value < 0 && (this.c == 'o' || this.c == 'x')) assert ((v += 256L) >= 0L) : v;
            this.print(v);
        }

        private void print(short value) throws IOException {
            long v = value;
            if (value < 0 && (this.c == 'o' || this.c == 'x')) assert ((v += 65536L) >= 0L) : v;
            this.print(v);
        }

        private void print(int value) throws IOException {
            long v = value;
            if (value < 0 && (this.c == 'o' || this.c == 'x')) assert ((v += 0x100000000L) >= 0L) : v;
            this.print(v);
        }

        private void print(long value) throws IOException {
            StringBuilder sb = new StringBuilder();
            if (this.c == 'd') {
                boolean neg = value < 0L;
                char[] va = value < 0L ? Long.toString(value, 10).substring(1).toCharArray() : Long.toString(value, 10).toCharArray();
                this.leadingSign(sb, neg);
                this.localizedMagnitude(sb, va, this.f, this.adjustWidth(this.width, this.f, neg));
                this.trailingSign(sb, neg);
            } else if (this.c == 'o') {
                int len;
                this.checkBadFlags(Flags.PARENTHESES, Flags.LEADING_SPACE, Flags.PLUS);
                String s = this.toOctalString(value);
                int n = len = this.f.contains(Flags.ALTERNATE) ? s.length() + 1 : s.length();
                if (this.f.contains(Flags.ALTERNATE)) {
                    sb.append('0');
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    int i = 0;
                    while (i < this.width - len) {
                        sb.append('0');
                        ++i;
                    }
                }
                sb.append(s);
            } else if (this.c == 'x') {
                int len;
                this.checkBadFlags(Flags.PARENTHESES, Flags.LEADING_SPACE, Flags.PLUS);
                String s = Long.toHexString(value);
                int n = len = this.f.contains(Flags.ALTERNATE) ? s.length() + 2 : s.length();
                if (this.f.contains(Flags.ALTERNATE)) {
                    sb.append(this.f.contains(Flags.UPPERCASE) ? "0X" : "0x");
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    int i = 0;
                    while (i < this.width - len) {
                        sb.append('0');
                        ++i;
                    }
                }
                if (this.f.contains(Flags.UPPERCASE)) {
                    s = s.toUpperCase();
                }
                sb.append(s);
            }
            Formatter.this.a.append(this.justify(sb.toString()));
        }

        private String toOctalString(long l) {
            return this.toUnsignedStringLong(l, 3);
        }

        private String toUnsignedStringLong(long i, int shift) {
            char[] buffer = new char[64];
            int mask = (1 << shift) - 1;
            int ptrBuffer = 64;
            do {
                buffer[--ptrBuffer] = this.charValue((int)i & mask);
            } while ((i >>>= shift) != 0L);
            return new String(buffer, ptrBuffer, 64 - ptrBuffer);
        }

        private char charValue(int digit) {
            if (digit >= 0 && digit <= 9) {
                return (char)(digit + 48);
            }
            if (digit >= 10 && digit <= 35) {
                return (char)(digit + 87);
            }
            throw new IndexOutOfBoundsException();
        }

        private StringBuilder leadingSign(StringBuilder sb, boolean neg) {
            if (!neg) {
                if (this.f.contains(Flags.PLUS)) {
                    sb.append('+');
                } else if (this.f.contains(Flags.LEADING_SPACE)) {
                    sb.append(' ');
                }
            } else if (this.f.contains(Flags.PARENTHESES)) {
                sb.append('(');
            } else {
                sb.append('-');
            }
            return sb;
        }

        private StringBuilder trailingSign(StringBuilder sb, boolean neg) {
            if (neg && this.f.contains(Flags.PARENTHESES)) {
                sb.append(')');
            }
            return sb;
        }

        private void print(float value, Object arg) throws IOException {
            this.print((double)value, arg);
        }

        private void print(double value, Object arg) throws IOException {
            boolean neg;
            StringBuilder sb = new StringBuilder();
            boolean bl = neg = Double.compare(value, 0.0) == -1;
            if (!Double.isNaN(value)) {
                double v = Math.abs(value);
                if (Double.compare(v, 0.0) == -1) {
                    v *= -1.0;
                }
                this.leadingSign(sb, neg);
                if (!Double.isInfinite(v)) {
                    this.print(sb, v, this.f, this.c, this.precision, neg, arg);
                } else {
                    sb.append(this.f.contains(Flags.UPPERCASE) ? "INFINITY" : "Infinity");
                }
                this.trailingSign(sb, neg);
            } else {
                sb.append(this.f.contains(Flags.UPPERCASE) ? "NAN" : "NaN");
            }
            Formatter.this.a.append(this.justify(sb.toString()));
        }

        private void print(StringBuilder sb, double value, Flags f, char c, int precision, boolean neg, Object arg) throws IOException {
            int prec = precision == -1 ? 6 : precision;
            FormattedFloatingDecimal fd = FormattedFloatingDecimal.valueOf(value, prec, arg);
            char[] mant = this.addZeros(fd.getMantissa(), prec);
            if (f.contains(Flags.ALTERNATE) && prec == 0) {
                mant = this.addDot(mant);
            }
            int newW = this.width;
            if (this.width != -1) {
                newW = this.adjustWidth(this.width, f, neg);
            }
            this.localizedMagnitude(sb, mant, f, newW);
        }

        private char[] addZeros(char[] v, int prec) {
            int i = 0;
            while (i < v.length) {
                if (v[i] == '.') break;
                ++i;
            }
            boolean needDot = false;
            if (i == v.length) {
                needDot = true;
            }
            int outPrec = v.length - i - (needDot ? 0 : 1);
            assert (outPrec <= prec);
            if (outPrec == prec) {
                return v;
            }
            char[] tmp = new char[v.length + prec - outPrec + (needDot ? 1 : 0)];
            System.arraycopy(v, 0, tmp, 0, v.length);
            int start = v.length;
            if (needDot) {
                tmp[v.length] = 46;
                ++start;
            }
            int j = start;
            while (j < tmp.length) {
                tmp[j] = 48;
                ++j;
            }
            return tmp;
        }

        private int adjustWidth(int width, Flags f, boolean neg) {
            int newW = width;
            if (newW != -1 && neg && f.contains(Flags.PARENTHESES)) {
                --newW;
            }
            return newW;
        }

        private char[] addDot(char[] mant) {
            char[] tmp = mant;
            tmp = new char[mant.length + 1];
            System.arraycopy(mant, 0, tmp, 0, mant.length);
            tmp[tmp.length - 1] = 46;
            return tmp;
        }

        private void failMismatch(Flags f, char c) {
            String fs = f.toString();
            throw new FormatFlagsConversionMismatchException(fs, c);
        }

        private void failConversion(char c, Object arg) {
            throw new IllegalFormatConversionException(c, arg.getClass());
        }

        private char getZero() {
            return '0';
        }

        private StringBuilder localizedMagnitude(StringBuilder sb, char[] value, Flags f, int width) {
            int len;
            if (sb == null) {
                sb = new StringBuilder();
            }
            int begin = sb.length();
            char zero = this.getZero();
            char grpSep = '\u0000';
            int grpSize = -1;
            char decSep = '\u0000';
            int dot = len = value.length;
            int j = 0;
            while (j < len) {
                if (value[j] == '.') {
                    dot = j;
                    break;
                }
                ++j;
            }
            if (dot < len) {
                decSep = '.';
            }
            j = 0;
            while (j < len) {
                if (j == dot) {
                    sb.append(decSep);
                    grpSep = '\u0000';
                } else {
                    char c = value[j];
                    sb.append((char)(c - 48 + zero));
                    if (grpSep != '\u0000' && j != dot - 1 && (dot - j) % grpSize == 1) {
                        sb.append(grpSep);
                    }
                }
                ++j;
            }
            len = sb.length();
            if (width != -1 && f.contains(Flags.ZERO_PAD)) {
                int k = 0;
                while (k < width - len) {
                    sb.insert(begin, zero);
                    ++k;
                }
            }
            return sb;
        }
    }

    private static interface FormatString {
        public int index();

        public void print(Object var1) throws IOException;

        public String toString();
    }
}

