/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import ej.annotation.Nullable;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedList<E>
extends AbstractSequentialList<E>
implements List<E>,
Deque<E>,
Cloneable,
Serializable {
    transient int size = 0;
    @Nullable
    transient Node<E> first;
    @Nullable
    transient Node<E> last;
    private static final long serialVersionUID = 876323262645176354L;

    public LinkedList() {
    }

    public LinkedList(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    private void linkFirst(E e) {
        Node<E> f = this.first;
        Node<E> newNode = new Node<E>(null, e, f);
        this.first = newNode;
        if (f == null) {
            this.last = newNode;
        } else {
            f.prev = newNode;
        }
        ++this.size;
        ++this.modCount;
    }

    void linkLast(E e) {
        Node<E> l = this.last;
        Node<E> newNode = new Node<E>(l, e, null);
        this.last = newNode;
        if (l == null) {
            this.first = newNode;
        } else {
            l.next = newNode;
        }
        ++this.size;
        ++this.modCount;
    }

    void linkBefore(E e, Node<E> succ) {
        Node pred = succ.prev;
        Node newNode = new Node(pred, e, succ);
        succ.prev = newNode;
        if (pred == null) {
            this.first = newNode;
        } else {
            pred.next = newNode;
        }
        ++this.size;
        ++this.modCount;
    }

    private E unlinkFirst(Node<E> f) {
        Object element = f.item;
        Node next = f.next;
        f.item = null;
        f.next = null;
        this.first = next;
        if (next == null) {
            this.last = null;
        } else {
            next.prev = null;
        }
        --this.size;
        ++this.modCount;
        return element;
    }

    private E unlinkLast(Node<E> l) {
        Object element = l.item;
        Node prev = l.prev;
        l.item = null;
        l.prev = null;
        this.last = prev;
        if (prev == null) {
            this.first = null;
        } else {
            prev.next = null;
        }
        --this.size;
        ++this.modCount;
        return element;
    }

    E unlink(Node<E> x) {
        Object element = x.item;
        Node next = x.next;
        Node prev = x.prev;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
            x.prev = null;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
            x.next = null;
        }
        x.item = null;
        --this.size;
        ++this.modCount;
        return element;
    }

    @Override
    public E getFirst() {
        Node<E> f = this.first;
        if (f == null) {
            throw new NoSuchElementException();
        }
        return f.item;
    }

    @Override
    public E getLast() {
        Node<E> l = this.last;
        if (l == null) {
            throw new NoSuchElementException();
        }
        return l.item;
    }

    @Override
    public E removeFirst() {
        Node<E> f = this.first;
        if (f == null) {
            throw new NoSuchElementException();
        }
        return this.unlinkFirst(f);
    }

    @Override
    public E removeLast() {
        Node<E> l = this.last;
        if (l == null) {
            throw new NoSuchElementException();
        }
        return this.unlinkLast(l);
    }

    @Override
    public void addFirst(E e) {
        this.linkFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.linkLast(e);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(E e) {
        this.linkLast(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            Node<E> x = this.first;
            while (x != null) {
                if (x.item == null) {
                    this.unlink(x);
                    return true;
                }
                x = x.next;
            }
        } else {
            Node<E> x = this.first;
            while (x != null) {
                if (o.equals(x.item)) {
                    this.unlink(x);
                    return true;
                }
                x = x.next;
            }
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Node<Object> pred;
        Node<E> succ;
        this.checkPositionIndex(index);
        Object[] a = c.toArray();
        int numNew = a.length;
        if (numNew == 0) {
            return false;
        }
        if (index == this.size) {
            succ = null;
            pred = this.last;
        } else {
            succ = this.node(index);
            pred = succ.prev;
        }
        Object[] objectArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Object o;
            Object e = o = objectArray[n2];
            Node<Object> newNode = new Node<Object>(pred, e, null);
            if (pred == null) {
                this.first = newNode;
            } else {
                pred.next = newNode;
            }
            pred = newNode;
            ++n2;
        }
        if (succ == null) {
            this.last = pred;
        } else {
            pred.next = succ;
            succ.prev = pred;
        }
        this.size += numNew;
        ++this.modCount;
        return true;
    }

    @Override
    public void clear() {
        Node<E> x = this.first;
        while (x != null) {
            Node next = x.next;
            x.item = null;
            x.next = null;
            x.prev = null;
            x = next;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public E get(int index) {
        this.checkElementIndex(index);
        return this.node((int)index).item;
    }

    @Override
    public E set(int index, E element) {
        this.checkElementIndex(index);
        Node<E> x = this.node(index);
        Object oldVal = x.item;
        x.item = element;
        return oldVal;
    }

    @Override
    public void add(int index, E element) {
        this.checkPositionIndex(index);
        if (index == this.size) {
            this.linkLast(element);
        } else {
            this.linkBefore(element, this.node(index));
        }
    }

    @Override
    public E remove(int index) {
        this.checkElementIndex(index);
        return this.unlink(this.node(index));
    }

    private boolean isElementIndex(int index) {
        return index >= 0 && index < this.size;
    }

    private boolean isPositionIndex(int index) {
        return index >= 0 && index <= this.size;
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    private void checkElementIndex(int index) {
        if (!this.isElementIndex(index)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private void checkPositionIndex(int index) {
        if (!this.isPositionIndex(index)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    Node<E> node(int index) {
        if (index < this.size >> 1) {
            Node<E> x = this.first;
            int i = 0;
            while (i < index) {
                x = x.next;
                ++i;
            }
            return x;
        }
        Node<E> x = this.last;
        int i = this.size - 1;
        while (i > index) {
            x = x.prev;
            --i;
        }
        return x;
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            Node<E> x = this.first;
            while (x != null) {
                if (x.item == null) {
                    return index;
                }
                ++index;
                x = x.next;
            }
        } else {
            Node<E> x = this.first;
            while (x != null) {
                if (o.equals(x.item)) {
                    return index;
                }
                ++index;
                x = x.next;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = this.size;
        if (o == null) {
            Node<E> x = this.last;
            while (x != null) {
                --index;
                if (x.item == null) {
                    return index;
                }
                x = x.prev;
            }
        } else {
            Node<E> x = this.last;
            while (x != null) {
                --index;
                if (o.equals(x.item)) {
                    return index;
                }
                x = x.prev;
            }
        }
        return -1;
    }

    @Override
    @Nullable
    public E peek() {
        Node<E> f = this.first;
        return f == null ? null : (E)f.item;
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    @Nullable
    public E poll() {
        Node<E> f = this.first;
        return f == null ? null : (E)this.unlinkFirst(f);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    @Nullable
    public E peekFirst() {
        Node<E> f = this.first;
        return f == null ? null : (E)f.item;
    }

    @Override
    @Nullable
    public E peekLast() {
        Node<E> l = this.last;
        return l == null ? null : (E)l.item;
    }

    @Override
    @Nullable
    public E pollFirst() {
        Node<E> f = this.first;
        return f == null ? null : (E)this.unlinkFirst(f);
    }

    @Override
    @Nullable
    public E pollLast() {
        Node<E> l = this.last;
        return l == null ? null : (E)this.unlinkLast(l);
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (o == null) {
            Node<E> x = this.last;
            while (x != null) {
                if (x.item == null) {
                    this.unlink(x);
                    return true;
                }
                x = x.prev;
            }
        } else {
            Node<E> x = this.last;
            while (x != null) {
                if (o.equals(x.item)) {
                    this.unlink(x);
                    return true;
                }
                x = x.prev;
            }
        }
        return false;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.checkPositionIndex(index);
        return new ListItr(index);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    private LinkedList<E> superClone() {
        try {
            return (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object clone() {
        LinkedList clone = this.superClone();
        clone.last = null;
        clone.first = null;
        clone.size = 0;
        clone.modCount = 0;
        Node<E> x = this.first;
        while (x != null) {
            clone.add(x.item);
            x = x.next;
        }
        return clone;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        Node<E> x = this.first;
        while (x != null) {
            result[i++] = x.item;
            x = x.next;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            return super.toArray(a);
        }
        int i = 0;
        T[] result = a;
        Node<E> x = this.first;
        while (x != null) {
            result[i++] = x.item;
            x = x.next;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    private class DescendingIterator
    implements Iterator<E> {
        private final ListItr itr;

        private DescendingIterator() {
            this.itr = new ListItr(LinkedList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private class ListItr
    implements ListIterator<E> {
        @Nullable
        private Node<E> lastReturned = null;
        @Nullable
        private Node<E> next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int index) {
            this.expectedModCount = LinkedList.this.modCount;
            this.next = index == LinkedList.this.size ? null : LinkedList.this.node(index);
            this.nextIndex = index;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < LinkedList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next = this.next == null ? LinkedList.this.last : this.next.prev;
            this.lastReturned = this.next;
            --this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Node lastNext = this.lastReturned.next;
            LinkedList.this.unlink(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = lastNext;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e) {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.item = e;
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            this.lastReturned = null;
            if (this.next == null) {
                LinkedList.this.linkLast(e);
            } else {
                LinkedList.this.linkBefore(e, this.next);
            }
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        final void checkForComodification() {
            if (LinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Node<E> {
        @Nullable
        E item;
        @Nullable
        Node<E> next;
        @Nullable
        Node<E> prev;

        Node(@Nullable Node<E> prev, E element, @Nullable Node<E> next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }
    }
}

