/*
 * Decompiled with CFR 0.152.
 */
package com.microej.android.application;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import com.microej.android.MicroEJSupport;
import com.microej.android.application.ApplicationDisplay;
import com.microej.android.application.ApplicationSupport;
import com.microej.android.application.MicroEJView;
import java.lang.reflect.InvocationTargetException;

public abstract class MicroEJActivity
extends Activity {
    private MicroEJView view;

    protected abstract String getApplicationMainClass();

    protected void runApplication() {
        String mainClassName = this.getApplicationMainClass();
        try {
            Class<?> mainClass = Class.forName(mainClassName);
            mainClass.getMethod("main", String[].class).invoke(null, new Object[]{new String[0]});
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            System.err.println("Error invoking main method of main class");
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ApplicationSupport applicationSupport = MicroEJSupport.getApplicationSupport();
        applicationSupport.startup();
        applicationSupport.setContext((Context)this);
        this.view = new MicroEJView((Context)this);
        this.view.setOnTouchListener(this.createOnTouchListener());
        this.setContentView(this.view);
        new Thread(new Runnable(){

            @Override
            public void run() {
                MicroEJActivity.this.runApplication();
            }
        }).start();
    }

    private View.OnTouchListener createOnTouchListener() {
        return new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                return MicroEJActivity.this.handleTouchEvent(event);
            }
        };
    }

    private boolean handleTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                MicroEJSupport.getApplicationSupport().onPointerPress((ApplicationDisplay)this.view, (int)event.getX(), (int)event.getY());
                return true;
            }
            case 1: 
            case 3: {
                MicroEJSupport.getApplicationSupport().onPointerRelease((ApplicationDisplay)this.view);
                return true;
            }
            case 2: {
                MicroEJSupport.getApplicationSupport().onPointerMove((ApplicationDisplay)this.view, (int)event.getX(), (int)event.getY());
                return true;
            }
        }
        return super.onTouchEvent(event);
    }
}

