/*
 * Decompiled with CFR 0.152.
 */
package ej.junit;

import ej.junit.TestListener;

public class CheckHelperTestListener
implements TestListener {
    private static final String RESULT_PLACEHOLDER = "{}";
    private static final String DEFAULT_STATUS_PATTERN = ".:[|{}|]:.";
    private final boolean verbose = Boolean.getBoolean("ej.junit.checkhelper.verbose");
    private final String passedTag;
    private final String failedTag;

    public CheckHelperTestListener() {
        String statusPattern = System.getProperty("ej.junit.status.pattern", DEFAULT_STATUS_PATTERN);
        if (!statusPattern.contains(RESULT_PLACEHOLDER)) {
            statusPattern = DEFAULT_STATUS_PATTERN;
        }
        this.passedTag = statusPattern.replace(RESULT_PLACEHOLDER, "PASSED");
        this.failedTag = statusPattern.replace(RESULT_PLACEHOLDER, "FAILED");
    }

    @Override
    public void testBeforeClassMethod(String testClass, String methodName) {
        if (this.verbose) {
            System.out.println("[JUNIT] Running @BeforeClass method: " + methodName);
        }
    }

    @Override
    public void testInstance(String testClass) {
        if (this.verbose) {
            System.out.println("[JUNIT] Instantiating: " + testClass);
        }
    }

    @Override
    public void testBeforeMethod(String testClass, String methodName) {
        if (this.verbose) {
            System.out.println("[JUNIT] Running @Before method: " + methodName);
        }
    }

    @Override
    public void testAfterMethod(String testClass, String methodName) {
        if (this.verbose) {
            System.out.println("[JUNIT] Running @After method: " + methodName);
        }
    }

    @Override
    public void testAfterClassMethod(String testClass, String methodName) {
        if (this.verbose) {
            System.out.println("[JUNIT] Running @AfterClass method: " + methodName);
        }
    }

    private void log(String text) {
        System.out.println("[JUNIT] " + text);
    }

    @Override
    public void onSuiteStart(String name) {
        this.log("Suite start\t" + name);
    }

    @Override
    public void onSuiteEnd(String name, int runs, int failures, int errors) {
        this.log("Suite end\t" + name);
        System.err.println(String.valueOf(failures == 0 && errors == 0 ? String.valueOf(this.passedTag) + ":\t" : String.valueOf(this.failedTag) + ":\t") + runs + " tests\t" + failures + " failures\t" + errors + " errors");
    }

    @Override
    public void onCaseStart(String name, String className, String file, int line) {
        this.log("Test start\t" + name + "\t" + className + "\t" + file + "\t" + line);
    }

    @Override
    public void onCaseEnd(String name, double duration) {
        this.log("Test end\t" + name + "\t" + duration + " seconds");
    }

    @Override
    public void onFailure(String message, String type, String trace) {
        this.log("Failure\t" + type + "\t" + message);
        this.log("TRACE START\n" + trace);
        this.log("TRACE END");
    }

    @Override
    public void onError(String message, String type, String trace) {
        this.log("Error\t" + type + "\t" + message);
        this.log("TRACE START\n" + trace);
        this.log("TRACE END");
    }

    @Override
    public void onSkip(String message) {
        this.log("Skipped\t" + message);
    }
}

