/*
 * Decompiled with CFR 0.152.
 */
package ej.rest.web;

import ej.rest.web.AbstractContent;
import ej.rest.web.AbstractResource;
import ej.rest.web.Content;
import ej.rest.web.JSONPathQuery;
import ej.rest.web.Resty;
import ej.rest.web.TextResource;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;
import org.json.me.JSONTokener;

public class JSONResource
extends AbstractResource {
    Object json;

    public JSONResource(Resty.Option ... options) {
        super(options);
    }

    public JSONArray array() throws IOException, JSONException {
        if (this.json == null) {
            this.unmarshal();
        }
        return (JSONArray)this.json;
    }

    public JSONObject object() throws IOException, JSONException {
        if (this.json == null) {
            this.unmarshal();
        }
        return (JSONObject)this.json;
    }

    public JSONObject toObject() throws IOException, JSONException {
        return this.object();
    }

    protected Object unmarshal() throws IOException, JSONException {
        int rsz;
        char[] buffer = new char[16];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(this.inputStream, "UTF-8");
        while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
            out.append(buffer, 0, rsz);
        }
        this.json = new JSONTokener(out.toString()).nextValue();
        this.inputStream.close();
        return this.json;
    }

    public JSONResource json(JSONPathQuery path) throws Exception {
        Object jsonValue = path.eval(this);
        return this.json(jsonValue.toString());
    }

    public JSONResource json(JSONPathQuery path, Content content) throws Exception {
        Object jsonValue = path.eval(this);
        return this.json(jsonValue.toString(), (AbstractContent)content);
    }

    public TextResource text(JSONPathQuery path) throws Exception {
        Object jsonValue = path.eval(this);
        return this.text(URI.create(jsonValue.toString()));
    }

    public Object get(String path) throws Exception {
        return new JSONPathQuery(path).eval(this);
    }

    public Object get(JSONPathQuery aQuery) throws Exception {
        return aQuery.eval(this);
    }

    @Override
    public String getAcceptedTypes() {
        return "application/json";
    }
}

