/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.session;

import ej.basictool.map.PackedMap;
import ej.bon.Timer;
import ej.bon.TimerTask;
import ej.hoka.session.Session;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;

public class SessionHandler {
    private static final long DEFAULT_SESSION_LIFETIME = 3600000L;
    private static final int TOKEN_SIZE = 128;
    private final Random randomNumberGenerator;
    private final long sessionLifetime;
    private final PackedMap<String, Session> sessions;

    public SessionHandler(Random random) {
        this(random, 3600000L);
    }

    public SessionHandler(Random random, long sessionLifetime) {
        this.randomNumberGenerator = random;
        this.sessionLifetime = sessionLifetime;
        this.sessions = new PackedMap();
        TimerTask cleanTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PackedMap packedMap = SessionHandler.this.sessions;
                synchronized (packedMap) {
                    Iterator sessionIterator = SessionHandler.this.sessions.values().iterator();
                    while (sessionIterator.hasNext()) {
                        Session s = (Session)sessionIterator.next();
                        if (!s.hasExpired()) continue;
                        sessionIterator.remove();
                    }
                }
            }
        };
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(cleanTask, new Date(), sessionLifetime * 1000L);
    }

    public Session newSession() {
        Session newSession = new Session(this.generateSessionID(), this.generateExpiration());
        this.sessions.put((Object)newSession.getId(), (Object)newSession);
        return newSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String sessionID) {
        PackedMap<String, Session> packedMap = this.sessions;
        synchronized (packedMap) {
            Session session;
            block6: {
                block5: {
                    session = (Session)this.sessions.get((Object)sessionID);
                    if (session != null) break block5;
                    return null;
                }
                if (!session.hasExpired()) break block6;
                this.sessions.remove((Object)session.getId());
                return null;
            }
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String sessionID) {
        PackedMap<String, Session> packedMap = this.sessions;
        synchronized (packedMap) {
            Session session;
            if (this.sessions.get((Object)sessionID) != null && (session = (Session)this.sessions.get((Object)sessionID)) != null) {
                session.setExpiration(this.generateExpiration());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSession(String sessionID) {
        PackedMap<String, Session> packedMap = this.sessions;
        synchronized (packedMap) {
            block4: {
                Session session = (Session)this.sessions.get((Object)sessionID);
                if (session == null) break block4;
                this.sessions.remove((Object)sessionID);
                return true;
            }
            return false;
        }
    }

    protected String generateSessionID() {
        byte[] sidBytes = new byte[128];
        this.randomNumberGenerator.nextBytes(sidBytes);
        return Base64.getEncoder().encodeToString(sidBytes);
    }

    protected long generateExpiration() {
        return System.currentTimeMillis() + this.sessionLifetime;
    }
}

