/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.body;

import ej.hoka.http.body.BodyParser;
import ej.hoka.http.body.StringBodyParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class MultipartStringsParser
implements BodyParser<String[]> {
    @Override
    public String[] parseBody(InputStream inputStream, String contentType) throws IOException {
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            String boundary = contentType.substring(contentType.indexOf(59) + 1);
            boundary = boundary.substring(boundary.indexOf("boundary=") + "boundary=".length());
            String multipartBody = new StringBodyParser().parseBody(inputStream, null);
            return MultipartStringsParser.split(multipartBody, boundary);
        }
        throw new IllegalArgumentException();
    }

    private static String[] split(String toSplit, String separator) {
        int index = toSplit.indexOf(separator);
        ArrayList<String> parts = new ArrayList<String>();
        while (index > -1) {
            int indexEnd = toSplit.indexOf(separator, index + separator.length());
            if (indexEnd != -1) {
                parts.add(toSplit.substring(index + separator.length() + 2, indexEnd - 4));
            } else {
                parts.add(toSplit.substring(index + separator.length() + 2, toSplit.length() - 2));
            }
            index = indexEnd;
        }
        return parts.toArray(new String[parts.size()]);
    }
}

