/*
 * Decompiled with CFR 0.152.
 */
package ej.motion.util;

public class TossHelper {
    private static final long SECOND = 1000L;

    private TossHelper() {
    }

    public static int computeExpectedStop(int start, float speed, long duration) {
        return (int)((float)start + speed * (float)duration / 1000.0f);
    }

    public static int computeStop(int start, int[] steps, float speed, long duration) {
        int stop = start;
        int expectedStop = TossHelper.computeExpectedStop(start, speed, duration);
        long shift = Long.MAX_VALUE;
        for (int step : steps) {
            long stepShift = Math.abs((long)step - (long)expectedStop);
            if (stepShift >= shift) continue;
            shift = stepShift;
            stop = step;
        }
        return stop;
    }
}

