/*
 * Decompiled with CFR 0.152.
 */
package ej.motion.util;

import ej.bon.Timer;
import ej.bon.TimerTask;
import ej.motion.Motion;
import ej.motion.util.MotionListener;
import java.util.List;

public class MotionAnimator {
    private final List<Motion> motions;
    private final boolean loop;
    private final MotionListener listener;
    private Motion currentMotion;
    private int currentMotionIndex;
    private TimerTask task;

    public MotionAnimator(Motion motion, MotionListener listener) {
        this(null, motion, listener, false);
    }

    public MotionAnimator(List<Motion> motions, MotionListener listener, boolean loop) {
        this(motions, motions.get(0), listener, loop);
    }

    private MotionAnimator(List<Motion> motions, Motion motion, MotionListener listener, boolean loop) {
        this.motions = motions;
        this.listener = listener;
        this.currentMotion = motion;
        this.loop = loop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Timer timer, long period) {
        this.stop();
        this.currentMotion.start();
        this.listener.start(this.currentMotion.getStartValue());
        MotionTask task = new MotionTask();
        MotionAnimator motionAnimator = this;
        synchronized (motionAnimator) {
            timer.schedule((TimerTask)task, 0L, period);
            this.task = task;
        }
    }

    public void stop() {
        if (this.cancelTask()) {
            this.listener.stop(this.currentMotion.getStopValue());
        }
    }

    public void cancel() {
        if (this.cancelTask()) {
            this.listener.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelTask() {
        TimerTask oldTask;
        MotionAnimator motionAnimator = this;
        synchronized (motionAnimator) {
            oldTask = this.task;
            if (oldTask == null) {
                return false;
            }
            this.task = null;
        }
        oldTask.cancel();
        return true;
    }

    private class MotionTask
    extends TimerTask {
        private MotionTask() {
        }

        public void run() {
            if (MotionAnimator.this.currentMotion.isFinished()) {
                List motionsLocal = MotionAnimator.this.motions;
                if (motionsLocal == null) {
                    MotionAnimator.this.stop();
                    return;
                }
                if (motionsLocal.size() == ++MotionAnimator.this.currentMotionIndex) {
                    if (MotionAnimator.this.loop) {
                        MotionAnimator.this.currentMotionIndex = 0;
                    } else {
                        MotionAnimator.this.stop();
                        return;
                    }
                }
                MotionAnimator.this.currentMotion = (Motion)motionsLocal.get(MotionAnimator.this.currentMotionIndex);
                MotionAnimator.this.currentMotion.start();
            }
            int value = MotionAnimator.this.currentMotion.getCurrentValue();
            MotionAnimator.this.listener.step(value);
        }
    }
}

